pro get_pionierdata
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read all PIONIER data files (OIFITS) in the current directory.
; Merge all data with the same spectral setup, also checking the OI_WAVELNGTH
; tables.
; Output data in OIFITS.
;
; Reduced (i.e., uncalibrated) data
files=findfile('PIONI.*_oidata.fits')
if strlen(files[0]) eq 0 then begin
	files=findfile('????-??-??_*_oidataCalibrated.fits')
	if strlen(files[0]) eq 0 then begin
		print,'No PIONIER files!'
		return
	endif else begin
		print,'Merging calibrated data.'
		prefix='DATE'
	endelse
endif else begin
	print,'Merging uncalibrated data.'
	prefix='PIONI'
endelse
;
n=n_elements(files)
configurations=strarr(n)
shortconfigids=strarr(n)
;
for i=0,n-1 do begin
;
if prefix eq 'PIONI' then begin
	fitsfile=obj_new('fitsfile',files[i])
	prihead=fitsfile->prihead()
;
	insmode1=strtrim(prihead->getpar('INS FILT1 NAME'))
	insmode2=strtrim(prihead->getpar('INS OPTI2 ID'))
	readout=strtrim(prihead->getpar('DET READOUT MODE'),2)
	nreads=strtrim(prihead->getpar('DET SCAN NREADS'),2)
	dprtype=strtrim(prihead->getpar('DPR TYPE'))
;
	insmode=insmode1+'-'+insmode2
	configid=readout+'+'+nreads
;
	station_1=vlti_stationid(strtrim(prihead->getpar('ISS CONF STATION1')))
	station_2=vlti_stationid(strtrim(prihead->getpar('ISS CONF STATION2')))
	station_3=vlti_stationid(strtrim(prihead->getpar('ISS CONF STATION3')))
	station_4=vlti_stationid(strtrim(prihead->getpar('ISS CONF STATION4')))
;
	if strpos(dprtype,'OBJECT') ge 0 then $
	configurations[i]=insmode+'+'+strtrim(string(configid),2) $
				 +'+'+station_1 $
				 +'-'+station_2 $
				 +'-'+station_3 $
				 +'-'+station_4
	shortconfigids[i]=insmode $
				 +'+'+station_1 $
				 +'-'+station_2 $
				 +'-'+station_3 $
				 +'-'+station_4
;
	obj_destroy,fitsfile
endif else begin
	array=mrdfits(files[i],3,h)
	stations=strjoin(array.sta_name,'-')
	wavelength=mrdfits(files[i],2,h)
	words=nameparse(h[where(strpos(h,'INSNAME') eq 0)],'=')
	insmode=strtrim(words[1],2)
	insmode=strmid(insmode,1,strlen(insmode)-2)
	words=nameparse(insmode,'/')
	insmode=strjoin(words,'-')
	strput,insmode,'_',strpos(insmode,'(')
	strput,insmode,'_',strpos(insmode,')')
;
	configurations[i]=strmid(files[i],0,10)+'_'+insmode+stations
endelse
;
endfor
;
; Unique configuration lists
index=where(strlen(configurations) ne 0,count)
; if count eq 0 then return
uconfs=unique([configurations[index]])
;
; Merge files with same configuration
for i=0,n_elements(uconfs)-1 do begin
	outfile=uconfs[i]+'.oifits'
	if prefix eq 'PIONI' then outfile='PIONI.'+uconfs[i]+'.oifits'
	index=where(configurations eq uconfs[i])
	merge_oidata,infiles=files[index],outfile=outfile, $
	 oiarray_out,oitarget_out,oiwavelength_out,oivis_out,oivis2_out,oit3_out
;	Merge wavelength tables as much as possible
	if 0 then begin
	nob=n_elements(oiwavelength_out)
	setups=strarr(nob)
	nch=n_elements(*oiwavelength_out[0].eff_wave)
	wavelengths=fltarr(nch,nob)
	for j=0,nob-1 do begin
		wavelengths[*,j]=*oiwavelength_out[j].eff_wave
		setups[j]=strjoin(string(*oiwavelength_out[j].eff_wave))
	endfor
	usetups=unique(setups,index)
	nuob=n_elements(usetups)
	uwaves=fltarr(nch,nuob)
	uwaves=wavelengths[*,index]
	uwavemeans=fltarr(nch)
	for j=0,nch-1 do uwavemeans[j]=mean(uwaves[j,*])
	for j=0,nch-1 do $
	    wavelengths[j,*]=1e9*abs(wavelengths[j,*]-mean(uwaves[j,*])) ge 1.0
;	Index of table with significantly different wavelength layouts
	index0=where(total(wavelengths,1) eq 0,count0)
	index1=where(total(wavelengths,1) ne 0,count1)
	if count0 eq 0 then index=indgen(nob)
	if count0 eq nob then index=0
	if count0 gt 0 and count1 lt nob then index=[index0[0],index1]
	oiwavelength_out=oiwavelength_out[index]
	put_oifits,outfile
	endif
	print,'Data saved to: '+outfile
endfor
;
end
