pro get_pointdata,filename
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read .con file and get auxilliary data. Calls procedures fixconfiguration
; and flagstations for fixes and updates of tables and configuration before
; proceeding.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(filename) ne 0 then begin
	hds_open,filename,'READ',status
	if status ne 0 then return
endif
;
get_format,format
if format ne 'CONSTRICTOR' then begin
	print,'***Error(GET_POINTDATA): wrong file format!'
	return
endif
;
get_scantable
get_sysconfig
get_bgdata
fixconfiguration
;
get_startable
get_numscan,n
if n gt 0 then begin
	get_points;,indgen(n)+1
	flagstations
	fixrefstation
endif
get_scanlog
get_observerlog
get_constrictorlog
;
; Default is to clear AMOEBA's data buffer and initialize Info arrays
if n_elements(freememory) eq 0 then freememory=1
if freememory then begin
	freememory
	GenInfo=replicate(GenConfig,1)
	GeoInfo=replicate(GeoParms,1)
endif
;
; Special check for output beams without baselines
index=where(genconfig.numbaseline ne 0,numoutbeam)
genconfig.numoutbeam=numoutbeam
;
end
