pro get_points,Iscan_ids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Load PointData for a list of scans. Some data integrity checking is done,
; in particular whether error/rms/uncertainty data is finite or not. The
; raw data averaging software can produce NaNs if the raw signal is constant
; but non-zero, in which case the square-root formula could get a small but
; negative argument.
;
; Also note that beginning with the 6-way observations at NPOI scan
; configuration (or subbarray as listed in scantable.station) is
; used to flag data involving unused stations.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
	FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
	DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
	NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
	GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
	PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
	ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
	VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
	TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
if hds_state() eq 0 then begin
	print,'***Error(GET_POINTS): no HDS file open!'
	return
endif
toplevel
if checkdata([1,8]) ne 0 then return
;
; Find out about reference station of data
dat_find,'GENCONFIG'
dat_there,'REFSTATION',reply
if reply eq 1 then cmp_get0i,'REFSTATION',refstation else refstation=1
dat_annul
;
; If SidConId exists, NAT data are in the right place
dat_find,'GENCONFIG'
dat_find,'INPUTBEAM'
dat_there,'SIDCONID',reply
if reply eq 1 then use_sidcon=0 else use_sidcon=1
dat_annul
dat_annul
;
; If no scans are specified, load all data
if n_elements(Iscan_ids) eq 0 then Iscan_ids=indgen(n_elements(ScanTable))+1
scan_ids=Iscan_ids-1	; scan_ids used to address arrays, which start at 0!
num_scans=n_elements(scan_ids)	; This is the number of scans to be loaded
;
; Find out about the total number of points: MP
MP=long(total(ScanTable[scan_ids].NumPoint))
if MP eq 0 then begin
	print,'Warning(GET_POINTS): no valid data points found.'
	return
endif
;
; Find out about the maximum number of baselines/outputbeam: MB
MB=max(GenConfig.NumBaseline)
;
; Find out about the maximum number of spectral channels/outputbeam: MC
MC=max(GenConfig.NumSpecChan)
;
; Allocate arrays
; Note the /nozero keyword, which accelerates memory allocation.
; However, this should only be done for variables which are
; always present in the data!
;
PhotonRate=fltarr(GenConfig.NumOutBeam,MC,MP,/nozero)
PhotonRateErr=fltarr(GenConfig.NumOutBeam,MC,MP)-1
VisSq=fltarr(GenConfig.NumOutBeam,MC,MB,MP,/nozero)
VisSqErr=fltarr(GenConfig.NumOutBeam,MC,MB,MP)-1
;
; These arrays exist only for coherently averaged data
ComplexVis=fltarr(GenConfig.NumOutBeam,2,MC,MB,MP)
ComplexVisErr=fltarr(GenConfig.NumOutBeam,2,MC,MB,MP)-1
VisAmp=fltarr(GenConfig.NumOutBeam,MC,MB,MP)
VisAmpErr=fltarr(GenConfig.NumOutBeam,MC,MB,MP)-1
VisPhase=fltarr(GenConfig.NumOutBeam,MC,MB,MP)
VisPhaseErr=fltarr(GenConfig.NumOutBeam,MC,MB,MP)-1
;
; This array holds the group delay
SoftDelay=fltarr(GenConfig.NumOutBeam,MB,MP)
SoftDelayErr=fltarr(GenConfig.NumOutBeam,MB,MP)-1
;
; Jitter in FDL delay (error not measured)
DelayJitter=fltarr(GenConfig.NumOutBeam,MB,MP)
DelayJitterErr=fltarr(GenConfig.NumOutBeam,MB,MP)+1e-7
;
FDLPos=dblarr(GenConfig.NumSid,MP)
FDLPosErr=fltarr(GenConfig.NumSid,MP)+1e-6
NATJitter=fltarr(GenConfig.NumSid,MP)
NATJitterErr=fltarr(GenConfig.NumSid,MP)+1e-2
NATCounts=fltarr(GenConfig.NumSid,MP)
NATCountsErr=fltarr(GenConfig.NumSid,MP)+1
;
; Allocate these arrays full-size only if needed
if GenConfig.NumTriple gt 0 then begin
	ComplTriple=fltarr(GenConfig.NumTriple,2,MC,MP,/nozero)
	ComplTripleErr=fltarr(GenConfig.NumTriple,2,MC,MP,/nozero)
	TripleAmp=fltarr(GenConfig.NumTriple,MC,MP,/nozero)
	TripleAmpErr=fltarr(GenConfig.NumTriple,MC,MP,/nozero)
	TriplePhase=fltarr(GenConfig.NumTriple,MC,MP,/nozero)
	TriplePhaseErr=fltarr(GenConfig.NumTriple,MC,MP,/nozero)
endif else begin
;	ComplTriple=fltarr(1,2,MC,MP)
;	ComplTripleErr=fltarr(1,2,MC,MP)
;	TripleAmp=fltarr(1,MC,MP)
;	TripleAmpErr=fltarr(1,MC,MP)
;	TriplePhase=fltarr(1,MC,MP)
;	TriplePhaseErr=fltarr(1,MC,MP)
	ComplTriple=0
	ComplTripleErr=0
	TripleAmp=0
	TripleAmpErr=0
	TriplePhase=0
	TriplePhaseErr=0
endelse
PointTime=dblarr(MP,/nozero)
Iscan=ScanTable[scan_ids].Iscan
StarId=ScanTable[scan_ids].StarId
Rec0=lonarr(num_scans)
RecN=lonarr(num_scans)-1
print,'Allocated arrays for ',num_scans,' scans in ',GenConfig.NumOutBeam, $
	" ob's; MB =",MB,', MC =',MC,', MP =',MP, $
	format='(a,i3,a,i2,a,i2,a,i3,a,i5)'
;
; Get data
vdim=1L
max_items=100L
num_items=max_items
items=sindgen(num_items)	; This is for a listing of items loaded
for i=0,num_items-1 do items[i]='123456789012345'
complex_read=0
triples_read=0
;
dat_find,'SCANDATA'
dat_find,'POINTDATA'
;
; Before 2000-01-01, CONSTRICTOR would output some illegal values
parsedate,date,y,m,d
if julian(y,m,d) lt julian(2000L,1L,1L) $
	then !except=0 $ ; do not report math errors
	else !except=2   ; report math error immediately
r=machar() & tiny=r.xmin
;
FOR i=0,num_scans-1 DO BEGIN
	vdim=1L
	dat_cell,vdim,scan_ids[i]+1
;
	NumPoint=ScanTable[scan_ids[i]].NumPoint
	RecN[i]=max(RecN)+NumPoint
	Rec0[i]=RecN[i]-NumPoint+1
;
	name='TIME'
	dat_there,name,reply
	if reply eq 1 then begin
	dat_find,name
	size=0L
	dat_size,size
	if size ne NumPoint then begin
		print,'***Error(GET_POINTS): dimensions of '+ $
			name+' inconsistent with declarations!'
		return
	endif
	dat_get1d,NumPoint,v
	PointTime[Rec0[i]:RecN[i]]=v/1000 	; Convert to seconds
	dat_annul
	endif else print,'Warning(GET_POINTS(',i+1,'): Not found: ',name,'!'
;
        name='INPUTBEAM'
        dat_there,name,reply
        if reply eq 1 then begin
	dat_find,name
	for j=0L,GenConfig.NumSid-1 do begin
	 dat_cell,vdim,j+1
 	 list_names,comp_names
 	 for k=0,n_elements(comp_names)-1 do begin
 	  dat_find,comp_names[k]
	  if strtrim(comp_names[k]) eq 'FDLPOS' then begin
	   dat_size,size
	   icheck=0
	   if size ne NumPoint then begin
		print,'***Error(GET_POINTS): size of FDLPos not = NumPoint!'
		return
	   endif
	   dat_get1d,NumPoint,v
	   FDLPos[j,Rec0[i]:RecN[i]]=v
	   if scantable[scan_ids[i]].station(j) eq 0 $
	   or scantable[scan_ids[i]].code eq 0 then FDLPosErr[j,Rec0[i]:RecN[i]]=-1
 	  endif else if strtrim(comp_names[k]) eq 'FDLPOSERR' then begin
	   dat_size,size
	   icheck=0
	   if size ne NumPoint then begin
		print,'***Error(GET_POINTS): size of FDLPosErr not = NumPoint!'
		return
	   endif
	   dat_get1r,NumPoint,v
	   index=where(finite(v) eq 0,count)
	   if count gt 0 then v[index]=-1e-6
	   FDLPosErr[j,Rec0[i]:RecN[i]]=v
	   if scantable[scan_ids[i]].station(j) eq 0 $
	   or scantable[scan_ids[i]].code eq 0 then FDLPosErr[j,Rec0[i]:RecN[i]]= $
					       -abs(FDLPosErr[j,Rec0[i]:RecN[i]])
 	  endif else if strtrim(comp_names[k]) eq 'NATJITTER' then begin
 	   dat_size,size
 	   if size ne NumPoint then begin
  	    print,'***Error(GET_POINTS): size of NATJitter not = NumPoint!'
  	    return
 	   endif
 	   dat_get1r,NumPoint,v
	   jj=where(j+1 eq genconfig.sidconid[0:genconfig.numsid-1]) & jj=jj[0]
;	   Beginning in 2003, CONSTRICTOR puts the data into the right places
;	   if long(strmid(date,0,4)) ge 2003 then jj=j
	   if not use_sidcon then jj=j
 	   NATJitter[jj,Rec0[i]:RecN[i]]=v
	   if scantable[scan_ids[i]].station(jj) eq 0 then $
	   NATJitterErr[jj,Rec0[i]:RecN[i]]=-1e-2
 	  endif else if strtrim(comp_names[k]) eq 'NATCOUNTS' then begin
 	   dat_size,size
 	   if size ne NumPoint then begin
  	    print,'***Error(GET_POINTS): size of NATCounts not = NumPoint!'
  	    return
 	   endif
 	   dat_get1r,NumPoint,v
	   jj=where(j+1 eq genconfig.sidconid[0:genconfig.numsid-1]) & jj=jj[0]
;	   Beginning in 2003, CONSTRICTOR puts the data into the right places
;	   if long(strmid(date,0,4)) ge 2003 then jj=j
	   if not use_sidcon then jj=j
 	   NATCounts[jj,Rec0[i]:RecN[i]]=v
	   NATCountsErr[jj,Rec0[i]:RecN[i]]=sqrt(v)
	   if scantable[scan_ids[i]].station(jj) eq 0 then $
	   NATCountsErr[jj,Rec0[i]:RecN[i]]=-1e-2
	  endif else begin
;	   print,'Warning(GET_POINTS): data type unknown: ',comp_names(k)
	  endelse
	  dat_annul
	 endfor
  	 dat_annul
	endfor
	dat_annul
	endif else print,'Warning(GET_POINTS(',i+1,'): Not found: ',name,'!'
;
        name='OUTPUTBEAM'
        dat_there,name,reply
        if reply eq 1 then begin
	dat_find,name
	for j=0L,GenConfig.NumOutBeam-1 do begin
;	 Check to make sure at least one baseline is in this beam
	 if GenConfig.NumBaseline[j] eq 0 then continue
	 bindex=intarr(GenConfig.NumBaseline[j])
	 for l=0,n_elements(bindex)-1 do $
	  if scantable[scan_ids[i]].station(where(GenConfig.StationId $
					eq strmid(GenConfig.BaselineId[l,j],0,3))) eq 0 $
	  or scantable[scan_ids[i]].station(where(GenConfig.StationId $
					eq strmid(GenConfig.BaselineId[l,j],4,3))) eq 0 $
	  then bindex[l]=1
         if total(bindex) gt 0 then bindex=where(bindex eq 1) else bindex=-1
	 pflag=0
	 s1=intarr(genconfig.numsid)
	 s2=scantable[scan_ids[i]].station
	 for k=0,genconfig.numsid-1 do $
		s1[k]=strpos(strjoin(genconfig.baselineid[*,j]), $
				genconfig.stationid[k])
	 index=where(s1 ne -1 and s2 ne 0,count)
	 if count eq 0 then pflag=1
	 dat_cell,vdim,j+1
	 list_names,comp_names
	 for k=0,n_elements(comp_names)-1 do begin
  	  dat_find,comp_names[k]
	  if strtrim(comp_names[k]) eq 'VISSQ' then begin
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 3 then icheck=1
	   if dims[0] ne max(GenConfig.NumSpecChan[0:GenConfig.NumOutBeam-1]) then iche
	   if dims[1] ne max(GenConfig.NumBaseline[0:GenConfig.NumOutBeam-1]) then iche
	   if dims[2] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
	    print,'***Error(GET_POINTS): VisSq dimensions '+ $
	  	  'inconsistent with declarations!'
	    return
	   endif
	   dat_getnr,ndim,dims,v
	   VisSq[j,0:dims[0]-1,0:dims[1]-1,Rec0[i]:RecN[i]]=v
	  endif else if strtrim(comp_names[k]) eq 'VISSQERR' then begin
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 3 then icheck=1
	   if dims[0] ne max(GenConfig.NumSpecChan[0:GenConfig.NumOutBeam-1]) then iche
      	   if dims[1] ne max(GenConfig.NumBaseline[0:GenConfig.NumOutBeam-1]) the
	   if dims[2] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
		print,'***Error(GET_POINTS): VisSqErr dimensions '+ $
			'inconsistent with declarations!'
		return
	   endif
	   dat_getnr,ndim,dims,v
	   index=where(finite(v) eq 0,count)
	   if count gt 0 then v[index]=-1
	   index=where(abs(v) lt sqrt(tiny),count)
	   if count gt 0 then v[index]=-1
	   VisSqErr[j,0:dims[0]-1,0:dims[1]-1,Rec0[i]:RecN[i]]=v
	   if bindex[0] ne -1 then $
	   VisSqErr[j,0:dims[0]-1,bindex     ,Rec0[i]:RecN[i]]=-1
 	  endif else if strtrim(comp_names[k]) eq 'SOFTDELAY' then begin
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 2 then icheck=1
      	   if dims[0] ne max(GenConfig.NumBaseline[$
			   0:GenConfig.NumOutBeam-1]) then icheck=1
	   if dims[1] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
		print,'Warning(GET_POINTS): SoftDelay dimensions '+ $
			'inconsistent with declarations!'
	   endif else begin
	   	dat_getnr,ndim,dims,v
	   	SoftDelay[j,0:dims[0]-1,Rec0[i]:RecN[i]]=v
	   endelse
 	  endif else if strtrim(comp_names[k]) eq 'SOFTDELAYERR' then begin
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 2 then icheck=1
      	   if dims[0] ne max(GenConfig.NumBaseline[$
			   0:GenConfig.NumOutBeam-1]) then icheck=1
	   if dims[1] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
		print,'Warning(GET_POINTS): SoftDelayErr dimensions '+ $
			'inconsistent with declarations!'
	   endif else begin
	   	dat_getnr,ndim,dims,v
	   	index=where(finite(v) eq 0,count)
	   	if count gt 0 then v[index]=-1e-6
	   	index=where(abs(v) lt sqrt(tiny),count)
	   	if count gt 0 then v[index]=-1e-6
	   	SoftDelayErr[j,0:dims[0]-1,Rec0[i]:RecN[i]]=v
	        if bindex[0] ne -1 then $
	   	SoftDelayErr[j,bindex     ,Rec0[i]:RecN[i]]=-1e-6
	   endelse
	  endif else if strtrim(comp_names[k]) eq 'PHOTONRATE' then begin
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 2 then icheck=1
	   if dims[0] ne max(GenConfig.NumSpecChan[0:GenConfig.NumOutBeam-1]) then iche
	   if dims[1] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
		print,'***Error(GET_POINTS): PhotonRate dimensions '+ $
			'inconsistent with declarations!'
		return
	   endif
	   dat_getnr,ndim,dims,v
	   PhotonRate[j,0:dims[0]-1,Rec0[i]:RecN[i]]=v
	  endif else if strtrim(comp_names[k]) eq 'PHOTONRATEERR' then begin
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 2 then icheck=1
	   if dims[0] ne max(GenConfig.NumSpecChan[0:GenConfig.NumOutBeam-1]) then iche
	   if dims[1] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
		print,'***Error(GET_POINTS): PhotonRateErr dimensions '+ $
			'inconsistent with declarations!'
		return
	   endif
	   dat_getnr,ndim,dims,v
	   if pflag then v[*]=-1
	   index=where(finite(v) eq 0,count)
	   if count gt 0 then v[index]=-1
	   index=where(abs(v) lt sqrt(tiny),count)
	   if count gt 0 then v[index]=-1
	   PhotonRateErr[j,0:dims[0]-1,Rec0[i]:RecN[i]]=v
	  endif else if strtrim(comp_names[k]) eq 'COMPLEXVIS' then begin
	   complex_read=complex_read+1
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 4 then icheck=1
	   if dims[0] ne 2 then icheck=1
	   if dims[1] ne max(GenConfig.NumSpecChan[0:GenConfig.NumOutBeam-1]) then iche
      	   if dims[2] ne max(GenConfig.NumBaseline[0:GenConfig.NumOutBeam-1]) the
	   if dims[3] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
		print,'***Error(GET_POINTS): ComplexVis dimensions '+ $
			'inconsistent with declarations!'
		return
	   endif
	   dat_getnr,ndim,dims,v
	   ComplexVis[j,0:dims[0]-1,0:dims[1]-1,0:dims[2]-1,Rec0[i]:RecN[i]]=v
	  endif else if strtrim(comp_names[k]) eq 'COMPLEXVISERR' then begin
	   complex_read=complex_read+1
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 4 then icheck=1
	   if dims[0] ne 2 then icheck=1
	   if dims[1] ne max(GenConfig.NumSpecChan) then icheck=1
      	   if dims[2] ne max(GenConfig.NumBaseline) then icheck=1
	   if dims[3] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
		print,'***Error(GET_POINTS): ComplexVisErr dimensions '+ $
			'inconsistent with declarations!'
		return
	   endif
	   dat_getnr,ndim,dims,v
	   index=where(finite(v) eq 0,count)
	   if count gt 0 then v[index]=-1
	   index=where(abs(v) lt sqrt(tiny),count)
	   if count gt 0 then v[index]=-1
	   ComplexVisErr[j,0:dims[0]-1,0:dims[1]-1,0:dims[2]-1, $
							Rec0[i]:RecN[i]]=v
           if bindex[0] ne -1 then $
	   ComplexVisErr[j,0:dims[0]-1,0:dims[1]-1,bindex     , $
							Rec0[i]:RecN[i]]=-1
 	  endif else if strtrim(comp_names[k]) eq 'DELAYJITTER' then begin
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 2 then icheck=1
      	   if dims[0] ne max(GenConfig.NumBaseline[0:GenConfig.NumOutBeam-1]) the
	   if dims[1] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
		print,'***Error(GET_POINTS): DelayJitter dimensions '+ $
			'inconsistent with declarations!'
		return
	   endif
	   dat_getnr,ndim,dims,v
	   DelayJitter[j,0:dims[0]-1,Rec0[i]:RecN[i]]=v
	   if bindex[0] ne -1 then $
	   DelayJitterErr[j,bindex     ,Rec0[i]:RecN[i]]=-1e-6
	   if scantable[scan_ids[i]].code eq 0 then $
	   DelayJitterErr[j,*          ,Rec0[i]:RecN[i]]=-1e-6
	  endif else begin
;	   print,'Warning(GET_POINTS): data type unknown: ',comp_names(k),'!'
	  endelse
	  dat_annul
	 endfor
	 dat_annul
	endfor
	dat_annul
	endif else print,'Warning(GET_POINTS(',i+1,'): Not found: ',name,'!'
;
        if GenConfig.NumTriple gt 0 then begin
        name='TRIPLE'
        dat_there,name,reply
        if reply eq 1 then begin
	dat_find,name
	for j=0L,GenConfig.NumTriple-1 do begin
	 tflag=0
	 for l=0,2 do $
	  if scantable[scan_ids[i]].station( $
		where(GenConfig.StationId $
	    eq strmid(GenConfig.BaselineId[GenConfig.TripleBase[l,j], $
					   GenConfig.TripleBeam[l,j]],0,3))) eq 0 $
	  or scantable[scan_ids[i]].station( $
		where(GenConfig.StationId $
	    eq strmid(GenConfig.BaselineId[GenConfig.TripleBase[l,j], $
					   GenConfig.TripleBeam[l,j]],4,3))) eq 0 $
	  then tflag=1
	 dat_cell,vdim,j+1
	 list_names,comp_names
	 for k=0,n_elements(comp_names)-1 do begin
  	  dat_find,comp_names[k]
	  if strtrim(comp_names[k]) eq 'COMPLTRIPLE' then begin
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 3 then icheck=1
	   if dims[0] ne 2 then icheck=1
	   if dims[1] ne max(GenConfig.TripleNumChan[0:GenConfig.NumTriple-1]) then ich
	   if dims[2] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
	    print,'***Error(GET_POINTS): ComplTriple dimensions '+ $
	  	  'inconsistent with declarations!'
	    return
	   endif
	   dat_getnr,ndim,dims,v
	   ComplTriple[j,0:dims[0]-1,0:dims[1]-1,Rec0[i]:RecN[i]]=v
	   triples_read=triples_read+1
	  endif else if strtrim(comp_names[k]) eq 'COMPLTRIPLEERR' then begin
	   dat_shape,ndim,dims
	   icheck=0
	   if ndim ne 3 then icheck=1
	   if dims[0] ne 2 then icheck=1
	   if dims[1] ne max(GenConfig.TripleNumChan[0:GenConfig.NumTriple-1]) then ich
	   if dims[2] ne NumPoint then icheck=1
	   if icheck eq 1 then begin
	    print,'***Error(GET_POINTS): ComplTripleErr dimensions '+ $
	  	  'inconsistent with declarations!'
	    return
	   endif
	   dat_getnr,ndim,dims,v
	   if tflag then v[*]=-1
	   index=where(finite(v) eq 0,count)
	   if count gt 0 then v[index]=-1
	   index=where(abs(v) lt sqrt(tiny),count)
	   if count gt 0 then v[index]=-1
	   ComplTripleErr[j,0:dims[0]-1,0:dims[1]-1,Rec0[i]:RecN[i]]=v
	   triples_read=triples_read+1
	  endif else begin
;	   print,'***Error(GET_POINTS): data type unknown: ',comp_names(k)
	  endelse
	  dat_annul
	 endfor
	 dat_annul
	endfor
	dat_annul
	endif else print,'Warning(GET_POINTS(',i+1,'): Not found: ',name,'!'
	endif
;
	dat_annul
ENDFOR
;
; Check some variables for finiteness if before 2000-01-01
if !except eq 0 then begin
	index=where(finite(photonrate) eq 0,count)
	if count gt 0 then begin
		photonrate[index]=0
		photonrateerr[index]=-1
	endif
endif
r=check_math()
!except=1
;
; Check uniqueness of time stamps
if n_elements(PointTime) ne n_elements(unique(PointTime)) then begin
	print,'***Error(GET_POINTS): duplicate time stamps!'
	return
endif
;
if max(abs(PointTime)/3600) gt 24 then genconfig.date=nextdate(geoparms.date) $
			          else genconfig.date=geoparms.date
;
; Initialize calibrated delays
dispinit,'point'
;
; Re-reference "pos" data, if necessary
if GenConfig.refstation ne refstation then begin
	NewStation=GenConfig.refstation
	GenConfig.refstation=refstation
	referencestation,GenConfig.StationId[NewStation-1],'point'
endif
;
; Set amplitudes and phases
if complex_read eq num_scans*2*GenConfig.NumOutBeam $
    and complex_read gt 0 then set_visampphase $
else if complex_read gt 0 then $
	print,'***Error(GET_POINTS): fewer complex vis. found than expected!'
;
if triples_read eq num_scans*2*GenConfig.NumTriple $
    and GenConfig.NumTriple gt 0 then set_tripleampphase $
else if GenConfig.NumTriple gt 0 then $
	print,'***Error(GET_POINTS): fewer triple vis. found that expected!'
;
toplevel
calcgeo
;
print,'Data loaded.'
;
end
