pro get_position
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read Yale (1991) positions in catalogs/npoi/position.hdn.
; Note: data will replace current non-zero values!
;
common StarBase,startable,notes
;
index=where(startable.ra ne 0,p_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	ra=startable[index].ra
	dec=startable[index].dec
	hdn=startable[index].hdn
	status=dc_read_free(!oyster_dir+'starbase/position.hdn', $
		n,r,d,/col,ignore=['!'])
;
	for i=0,count-1 do begin
		j=where(n eq hdn[i],j_count)
		if j_count gt 0 then begin
			ra[i]=r[j[0]]
			dec[i]=d[j[0]]
		endif
	endfor
	startable[index].ra=ra
	startable[index].dec=dec
;
	index=where(startable.ra ne 0,p_count2)
	print,'Number of positions increased by: ',p_count2-p_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_POSITION): No stars with HDN name found!'
;
end
