pro get_ptidata,file,status
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read standard PTI file, e.g., /science/omileo/omileo.?.pti.
; Note that some PTI data files deviate in format and must be read with
; the appropriate procedure in get_ptidata.pro in the same directory.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common ModelFit,parameters,ds_options
;
SystemId='PTI'
;
pti_stars=''
pti_date=''
status=dc_read_free(file,pti_stars,n,mjd,pti_date,ut,delay,wl, $
	vissqc,vissqcerr,vissq,vissqerr,sysvis,sysviserr,n_cal,u,v,ha, $
	/col,ignore=['#'])
if status ne 0 then begin
	print,'***Error(GET_PTIDATA): error reading file ',file,'!'
	return
endif
num_scan=n_elements(ut)
;
parsepti,pti_date,y,m,d
Date=constrictordate(y[0],m[0],d[0])
;
; OYSTER's UT Date has only a single value, hence times are wrt to UT=0
; Check for single night with observations before UT=0, times will be < 0
night_start=24-system_config(systemid[0],'MIDNIGHT')
index=where(ut gt night_start,n)
if n gt 0 then begin
	Date=nextdate(Date)
	ut[index]=ut[index]-24
endif
;
NumSid=2
NumOutBeam=1
maxBaseline=1
maxSpecChan=5
maxNumTriple=10
maxConfig=1
GenConfig=allocgenconfig(NumSid,NumOutBeam,maxNumTriple, $
	maxBaseline,maxSpecChan,maxConfig)
;
if n_elements(unique(ut)) eq n_elements(ut) then GenConfig.BeamCombinerId=1 $
					    else GenConfig.BeamCombinerId=5
case GenConfig.BeamCombinerId of
	1:nc=1
	5:nc=5
endcase
;
GenConfig.Date=Date
GenConfig.NumSid=NumSid
GenConfig.Diameter=0.4
GenConfig.NumOutBeam=NumOutBeam
GenConfig.NumBaseline=[1]
GenConfig.NumSpecChan=[nc]
GenConfig.refstation=1
;
GenConfig.Wavelength[0,0]=2.2/1.d6
;
GenConfig.ChanWidth[0,0]=0.1/1.d6
;
GenConfig.BaselineId[0,0]='NAS-SAS'
GenConfig.StationId[0]=strmid(GenConfig.BaselineId[0,0],0,3)
GenConfig.StationId[1]=strmid(GenConfig.BaselineId[0,0],4,3)
;
; Prepare star IDs
stars='FKV'+string(cri(long(strmid(pti_stars,3,6)),'hdn-fkv'),format='(i4.4)')
;
scans=replicate(scan(),num_scan)
scans.iscan=indgen(num_scan)+1
scans.starid=stars
scans.time=ut*3600
scans.fdlpos[1]=delay
scans.fdlposerr[1]=1e-6
scans.fdlpos[0]=0
scans.fdlposerr[0]=1e-6
;
scans.VisSq[0,0,0]=vissq
scans.VisSqC[0,0,0]=vissqc
scans.VisSqErr[0,0,0]=vissqerr
scans.VisSqCErr[0,0,0]=vissqcerr
;
print,'ScanData read.'
;
; Create ScanTable
Iscan=lindgen(num_scan)+1	; Attention: First scan has ID 1!
ScanId=lindgen(num_scan)	; ScanId of embedded system
StartTime=dblarr(num_scan)
StopTime=dblarr(num_scan)
NumCoh=lonarr(num_scan)
NumIncoh=lonarr(num_scan)
NumPoint=lonarr(num_scan)
Code=lonarr(num_scan)+1
Station=lonarr(NumSid,Num_Scan)+1	; 1=station in, 0=station out
StarId=scans.starid
;
MaxSid=2
ScanTable=build_scantable(Iscan,ScanId,StarId,Code,Station, $
			StartTime,StopTime,NumPoint, $
			NumCoh,NumIncoh)
;
print,'Scantable created.'
;
get_startable
get_stationtable
get_geoparms
calcastrom
;
freememory
GenInfo=replicate(GenConfig,1)
GeoInfo=replicate(GeoParms,1)
;
if n_elements(ds_options) eq 0 then ds_options=alloc_ds_options()
ds_options.i=1	; True: interferometry loaded
ds_options.v2=1
ds_options.ta=0
ds_options.tp=0
;
end
