pro get_rawdata,filename
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; New standard procedure which will read and concatenate TimeStamp, LaserPos,
; and Geopos for all sub-scan raw files. These are items with
; time and siderostat indices only.
;
; Big ticket items like BinCounts are read from individual sub-scan files
; using different procedures. This item has a spectrometer (output beam) index.
;
; If filename is defined, it must be of the form YYYY-MM-DD.raw.NNN where NNN
; is the scan number. This will be expanded into all sub-scan file of the
; form YYYY-MM-DD.raw.NNN.NN.
;
; If no filename is provided, assume a sub-scan raw file is open and read
; it as usual. Leave the file open. Also leave the file open if the filename
; equates to just one file.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(filename) eq 0 then begin
	if hds_state() eq 0 then begin
		print,'***Error(GET_RAWDATA): no HDS file open!'
		return
	endif
	toplevel
	nf=1
endif else begin
	files=file_search(filename+'.??')
	nf=n_elements(files)
	if nf eq 0 then begin
		print,'Error(GET_RAWDATA): no files found!'
		return
	endif
	hds_open,files[nf-1],'READ',status
	if status ne 0 then return
endelse
;
get_format,format
if format ne 'COBRA' then begin
	hds_close
	print,'***Error(GET_RAWDATA): wrong file format! (File closed)'
	return
endif
get_scantable
get_sysconfig
fixconfiguration
scantable=replicate(scantable[0],nf)
get_bgdata
;
get_startable
if n_elements(filename) ne 0 then hds_close
;
numrec=0
for i=0,nf-1 do begin
	if n_elements(filename) ne 0 then hds_open,files[i]
	get_object,'scandata.numrec',n
	numrec=numrec+n[0]
	if n_elements(filename) ne 0 then hds_close
endfor
timestamp=dblarr(numrec)
geopos=dblarr(genconfig.numsid,numrec)
laserpos=dblarr(genconfig.numsid,numrec)
quadcounts=intarr(genconfig.numsid,4,numrec)
;
rec0=0
for i=0,nf-1 do begin
	if n_elements(filename) ne 0 then hds_open,files[i]
;
; 	If SidConId exists, NAT data are in the right place
	dat_find,'GENCONFIG'
	dat_find,'INPUTBEAM'
	dat_there,'SIDCONID',reply
	if reply eq 1 then use_sidcon=0 else use_sidcon=1
	dat_annul
	dat_annul
;
	dat_find,'scandata'
	cmp_get1i,'numrec',1,nrec & nrec=nrec[0]
	scantable[i].numpoint=nrec
	dat_find,'rawdata'
	dat_cell,1,1
	cmp_get1d,'time',nrec,time
	timestamp[rec0:rec0+nrec-1]=time
	dat_find,'inputbeam'
	for k=0,genconfig.numsid-1 do begin
	   	kk=where(k+1 eq genconfig.sidconid[0:genconfig.numsid-1])
		kk=kk[0]
;	   	Beginning in 2003, CONSTRICTOR puts the data into the right places
;	        if long(strmid(date,0,4)) ge 2003 then kk=k
	        if not use_sidcon then kk=k
		dat_cell,1,k+1
		dat_there,'QUAD',reply
		if reply then begin
			get_object,'Quad',c
			quadcounts[kk,*,rec0:rec0+nrec-1]=c
		endif
		dat_there,'GEOPOS',reply
		if reply then begin
			cmp_get1d,'GEOPOS',nrec,delay
			geopos[k,rec0:rec0+nrec-1]=delay
		endif
		cmp_get1d,'FDLDELAY',nrec,delay
		laserpos[k,rec0:rec0+nrec-1]=delay
		dat_annul
	endfor
	rec0=rec0+nrec
	if n_elements(filename) ne 0 and nf gt 1 then hds_close
endfor
;
; Reset the raw data pointers assuming bincounts are out of sync now
Raw0=0
RawN=0
;
print,'Raw data for star ',scantable.starid,' loaded.'
;
end
