pro get_reandma
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For stars loaded in StarTable, find them in the catalog of HgMn stars by
; Renson and Manfroid (by position, precision=2").
;
common StarBase,startable,notes
;
; Read notes to catalog
notes=''
status=dc_read_fixed(!catalogs_dir+'proprietary/reandma/notes.dat',notes,/col, $
	format='(a80)')
n=n_elements(l)
note_ids=long(notes)
; Read catalog.xdr to startable_rm, if it exists
rmfile=!catalogs_dir+'proprietary/reandma/catalog.xdr'
result=file_search(rmfile)
IF strlen(result[0]) ne 0 THEN restore,rmfile $
			  ELSE BEGIN
;
; Make copy of startable
if n_elements(startable) ne 0 then startable_in=startable
;
; Read catalog data from Renson and Manfroid
l=''
status=dc_read_fixed(!catalogs_dir+'proprietary/reandma/catalog.dat',l,/col, $
	format='(a155)',ignore=['!'])
n=n_elements(l)
create_startable,strarr(n)
;
for i=0,n-1 do begin
	startable[i].reference=strmid(l[i],1,5)
	startable[i].bsc=fix(strcompress(strmid(l[i],20,4),/remove_all))
	startable[i].hdn=long(strcompress(strmid(l[i],7,5),/remove_all))
	startable[i].hic=long(strcompress(strmid(l[i],14,6),/remove_all))
	startable[i].name=strmid(l[i],49,11)
	rah=float(strmid(l[i],74,2))
	ram=float(strmid(l[i],76,2))
	ras=float(strmid(l[i],78,5))
	startable[i].ra=rah+ram/60+ras/3600
	decd=float(strcompress(strmid(l[i],83,3),/remove_all))
	decm=float(strmid(l[i],86,2))
	decs=float(strmid(l[i],88,4))
	startable[i].dec=abs(decd)+decm/60+decs/3600
	if decd lt 0 then startable[i].dec=-startable[i].dec
	startable[i].mv=float(strcompress(strmid(l[i],92,4),/remove_all))
	startable[i].bv=float(strcompress(strmid(l[i],96,5),/remove_all))
	startable[i].spectrum=strmid(l[i],130,14)
endfor
startable_rm=startable
save,startable_rm,filename=!catalogs_dir+'proprietary/reandma/catalog.xdr'
;
startable=startable_in
sep=fltarr(n_elements(startable))
;
if 0 then begin
for i=0,n_elements(startable)-1 do $
	sep[i]=min(winkel(startable_rm.ra,startable_rm.dec,$
		startable[i].ra,startable[i].dec)*3600)
	histograph,sep,binsize=0.05,min=0,max=4
endif
;
ENDELSE
;
for i=0,n_elements(startable)-1 do begin
;
sep=winkel(startable_rm.ra,startable_rm.dec,startable[i].ra,startable[i].dec)
index=where(sep*3600 lt 2,n)
if n eq 1 then begin
	print,startable[i].starid+' is in list of Renson and Manfroid!'
;	Retrieve notes
	jndex=where(note_ids eq long(startable_rm[index].reference))
	print,notes[jndex]
endif
;
endfor
;
end
