pro get_records
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Obsolete!
; Read the raw data records from a CONSTRICTOR HDS file.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if hds_state() eq 0 then begin
	print,'***Error(GET_RECORDS): no HDS file open!'
	return
endif
toplevel
;
if checkdata([8]) ne 0 then return
;
numbin=GenConfig.NumBin
numsid=GenConfig.NumSid
numout=GenConfig.NumOutBeam
maxchn=max(GenConfig.NumSpecChan)
maxbas=max(GenConfig.NumBaseline)
numrec=long(total(ScanTable.NumPoint))
;
num_scans=1
dat_find,'SCANDATA'
dat_find,'RAWDATA'
FOR i=0,num_scans-1 DO BEGIN
	vdim=1L
	dat_cell,vdim,i+1
;
	get_object,'Time',TimeStamp
;
	dat_find,'OutputBeam'
	dat_cell,1,1
	dat_there,'SoftDelay',reply_soft
	dat_there,'BinCounts',reply_bins
	dat_annul
	if reply_soft then SoftDelay=fltarr(numout,maxbas,numrec)
	if reply_bins then BinCounts=bytarr(numout,numbin,maxchn,numrec)
	for i=0,numout-1 do begin
		dat_cell,1,i+1
		if reply_bins then begin
			get_object,'BinCounts',c
			BinCounts[i,*,*,*]=c
		endif
		if reply_soft then begin
			get_object,'SoftDelay',d
			SoftDelay[i,*,*]=d
		endif
		dat_annul
	endfor
	dat_annul
;
	LaserPos=dblarr(numsid,numrec)
	dat_find,'InputBeam'
	dat_cell,1,1
	dat_there,'Quad',reply_quad
	dat_there,'GeoDelay',reply_geo
	dat_annul
	if reply_quad then QuadCounts=fltarr(numsid,4,numrec)
	if reply_geo then GeoPos=dblarr(numsid,numrec)
	for i=0,numsid-1 do begin
		dat_cell,1,i+1
		get_object,'FDLDelay',d
		LaserPos[i,*]=d
		if reply_geo then begin
			get_object,'GeoDelay',d
			GeoPos[i,*]=d
		endif
		if reply_quad then begin
			get_object,'Quad',c
			QuadCounts[i,*,*]=c
		endif
		dat_annul
	endfor
ENDFOR
;
toplevel
;
print,'Records loaded.'
;
end
