pro get_richichi,init=init,update=update
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read VINCI calibrator list courtesy of A. Richichi (et al. 2009)
; Diameters are LD.
;
; If a StarTable is present (and init=0), update it with the information found.
; If no Startable is present or init=1, then read entire list and initialize
; a StarTable. If update=1, update hdn.xdr for HDN numbers not found.
;
common StarBase,startable,notes
;
if n_elements(init) eq 0 then init=0
;
if n_elements(startable) eq 0 or init then begin
	status=dc_read_free(!oyster_dir+'starbase/richichi.hdn',hdn,/col, $
		ignore=['!'])
	get_startable,'HDN'+string(hdn,format='(i6.6)')
	uindex=where(startable.hdn eq 0)
	startable.hdn=hdn
endif
;
index=where(startable.diameter ne 0,diameter_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	hdn=startable[index].hdn
	startable[index].bflag='.'
;
	sp=''
	vmag=''
	status=dc_read_free(!oyster_dir+'starbase/richichi.hdn', $
		hd,hr,ra,dec,pmra,pmdec,v,k,s,ld,lde, $
		/col,ignore=['!'])
;
	for i=0L,count-1 do begin
		j=where(hd eq hdn[i],j_count)
		if j_count eq 1 then begin
			startable[i].diameter=ld[j]
;			startable(i).diametere=lde(j)
			startable[i].spectrum=s[j]
			startable[i].mk=k[j]
			startable[i].bflag='C'
		endif
	endfor
;
	index=where(startable.diameter ne 0,diameter_count2)
	print,'Number of new diameters added: ', $
		diameter_count2-diameter_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_RICHICHI): No stars with HDN name found!'
;
; Make sure integer spectral types and classes are up-to-date
spec_parse
;
; Update HDN.xdr
if n_elements(uindex) ne 0 then begin
	if uindex[0] ne -1 and keyword_set(update) then $
	update_cat,startable[uindex].starid
endif
;
end
