pro get_sao
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read entire Smithsonian Astrophysical Catalog into reduced NPOI StarTable.
; Note that we cannot load the complete table due to limited memory!
;
common StarBase,StarTable,Notes
;
; With this n, you need 14 catalog reads to fill in the reduced table.
n=18496L
;
for i=0,13 do begin
	get_startable,'SAO'+stringl(lindgen(n)+1+i*n,format='(i6.6)')
	table_n=extract_npoi()
	if n_elements(table) ne 0 then begin
		table=merge_npoi(table,table_n)
	endif else table=table_n
endfor
;
StarTable=table
;
end
