pro get_sb9,starids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Create StarTable for starids and read from the SB9 data base by D. Pourbaix
; http://sb9.astro.ulb.ac.be/SB9public.tar.gz
; Remove StarTable entries for which no data was found.
;
common StarBase,StarTable,Notes
;
RAD=180/!pi
;
; Read sb9.xdr, if it exists
sb9file=!catalogs_dir+'sb9/sb9.xdr'
result=file_search(sb9file)
IF strlen(result[0]) ne 0 THEN restore,sb9file $
			  ELSE BEGIN
;
; Read Hipparcos catalog to be able identfy SB9 stars by coordinates
get_hip
t_hip=startable
get_hdn
t_hdn=startable
;
sb9main=!catalogs_dir+'sb9/Main.dta'
sb9orbits=!catalogs_dir+'sb9/Orbits.dta'
lm=''
s=dc_read_free(sb9main,lm,/col)
lo=''
s=dc_read_free(sb9orbits,lo,/col)
;
nm=n_elements(lm)
bat_m=lonarr(nm)
hip=lonarr(nm)
hdn=lonarr(nm)
ras=dblarr(nm)
dec=dblarr(nm)
mv1=fltarr(nm)+100
mv2=fltarr(nm)+100
mf1=strarr(nm)
mf2=strarr(nm)
sp1=strarr(nm)
sp2=strarr(nm)
;
; Read main data for mv, hip, and hdn IDs
for i=0,nm-1 do begin
	words=nameparse(lm[i],'|')
	bat_m[i]=fix(words[0])
	pos=words[2]
	ipos=max([strpos(pos,'+'),strpos(pos,'-')])
	ras[i]=hms2h(strmid(pos,0,ipos),/sb9)
	dec[i]=dms2d(strmid(pos,ipos),/sb9)
;	Find HIP from closest target
	dw=winkel(ras[i],dec[i],t_hip.ra,t_hip.dec)*3600; convert to "
	index=where(dw eq min(dw))
	if min(dw[index]) le 1.0 then hip[i]=t_hip[index].hic
;	Find HDN from closest target
	dw=winkel(ras[i],dec[i],t_hdn.ra,t_hdn.dec)*3600; convert to "
	index=where(dw eq min(dw))
	if min(dw[index]) le 1.0 then hdn[i]=t_hdn[index].hdn
;	Extract parameters from SB9
	if strlen(words[4]) ne 0 then mv1[i]=float(words[4])
	mf1[i]=words[5]
	if strlen(words[6]) ne 0 then mv2[i]=float(words[6])
	mf2[i]=words[7]
	sp1[i]=words[8]
	if n_elements(words) eq 10 then sp2[i]=words[9]
endfor
;
no=n_elements(lo)
bat_o=lonarr(no)
orb=lonarr(no)
who=strarr(no)
p=fltarr(no)
t=fltarr(no)
e=fltarr(no)
o=fltarr(no)
k1=fltarr(no)
k1e=fltarr(no)
k2=fltarr(no)
k2e=fltarr(no)
rv=fltarr(no)
;
; Read orbit data (contains more orbital solutions than main data)
for i=0,no-1 do begin
	words=nameparse(lo[i],'|')
	bat_o[i]=fix(words[0])
	orb[i]=fix(words[1])
	p[i]=float(words[2])
	t[i]=2440000.d0+float(words[4])
	e[i]=float(words[7])
	o[i]=float(words[9])
	if words[11] ne '-' then $
	k1[i]=float(words[11])
	if words[12] ne '-' and words[12] ne '>' and words[12] ne 'Fixed' then $
	k1e[i]=float(strcompress(words[12],/remove_all))
	if words[13] ne '-' then $
	k2[i]=float(words[13])
	if words[14] ne '-' and words[12] ne '>' and words[14] ne 'Fixed' then $
	k2e[i]=float(strcompress(words[14],/remove_all))
	if words[15] ne '-' then $
	rv[i]=float(strcompress(words[15],/remove_all))
	who[i]=words[23]
endfor
print,'Median error K1:',median(k1e)
print,'Median error K2:',median(k2e[where(k2e ne 0)])
;
create_startable,'HIP'+string(hip,format='(i6.6)')
StarTable.hic=hip
StarTable.hdn=hdn
index=where(startable.hic eq 0 and startable.hdn ne 0,count)
if count gt 0 then $
	startable[index].starid='HDN'+string(hdn[index],format='(i6.6)')
; Next line added 2021, based on improved crossindex hic-hdn
rename_starids,'hic-hdn'
StarTable.bat=bat_m
StarTable.mv=mv1
startable.dmv=100
index=where(mv2 ne 100,count)
if count gt 0 then begin
	StarTable[index].dmv=mv2[index]-mv1[index]
	StarTable[index].mv=cmag(mv1[index],mv2[index])	; mv1 is total magnitude
endif
StarTable.bflag='B'
StarTable.ra=ras
StarTable.dec=dec
;
; Assign the latest orbital elements
for i=0,nm-1 do begin
	index=where(bat_o eq bat_m[i])
	j=where(who[index] eq 'PBX',count)
	if count gt 1 then j=j[count-1]
	if count eq 0 then j=n_elements(index)-1
	StarTable[i].p=p[index[j]]
	StarTable[i].t=t[index[j]]
	StarTable[i].e=e[index[j]]
	StarTable[i].o=o[index[j]]
	StarTable[i].k1=k1[index[j]]
	StarTable[i].k2=k2[index[j]]
	StarTable[i].rv=rv[index[j]]
endfor
;
; Save this catalog to an XDR file
save,StarTable,filename=sb9file
;
ENDELSE
;
n=n_elements(starids)
if n ne 0 then begin
	index=lonarr(n)-1
	m=0
	for i=0,n-1 do begin
		k=where(startable.starid eq starids[i],l)
		if l gt 1 then index=[index,-1]
		if l gt 0 then index[i+m:i+m+l-1]=k
		if l gt 1 then m=m+1
	endfor
	jndex=where(index eq -1,count)
	for i=0,count-1 do print,'Star not found: ',starids[jndex[i]]
	jndex=where(index ge 0,count)
	if count gt 0 then begin
		index=index[jndex]
		startable=startable[index]
	endif
endif
;
end
