pro get_scandata,filename,freememory=freememory
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read entire .cha file and get auxilliary data. Also clear AMOEBA's buffer.
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common ModelFit,parameters,ds_options
;
if n_elements(filename) ne 0 then begin
	hds_open,filename,'READ',status
	if status ne 0 then return
endif
;
get_format,format
if format ne 'CHAMELEON' then begin
	print,'***Error(GET_SCANDATA): wrong format!'
	return
endif
;
get_scantable
get_sysconfig
get_startable
get_scans
calcastrom
calcviscal
get_scanlog
get_observerlog
get_constrictorlog
;
; We need to transfer this info from scantable to scans for older files
if total(scans.int_time) eq 0 then $
scans.int_time=scantable.stoptime-scantable.starttime
;
; Star names are not stored with StarTable, so get them from scans
index1=where(strlen(startable.name) eq 0,count1)
for i=0,count1-1 do begin
	index2=where(scans.starid eq startable[index1[i]].starid,count2)
	if count2 ge 1 then startable[index1[i]].name=scans[index2[0]].star
endfor
;
; Default is to clear AMOEBA's data buffer and initialize Info arrays
if n_elements(freememory) eq 0 then freememory=1
if freememory then begin
	freememory
	GenInfo=replicate(GenConfig,1)
	GeoInfo=replicate(GeoParms,1)
endif
;
if n_elements(ds_options) eq 0 then ds_options=alloc_ds_options()
;
; Set the available data types
ds_options.i=1	; True: interferometry loaded
ds_options.v2=1	; True: squared visibilities
ds_options.ta=1	; True: triple amplitudes
ds_options.tp=1	; True: triple phases
;
; If CHA file is not from NPOI, ignore triple amplitudes
if strpos(systemid,'NPOI') lt 0 then ds_options.ta=0
;
end
