pro get_scans
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read .cha output file of CHAMELEON. The procedure checks the reference
; station for the data, and re-references the delays if the current reference
; (as listed in GenConfig) is different.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if checkdata([7,8]) ne 0 then return
;
if hds_state() eq 0 then begin
	print,'***Error(GET_SCANS): no HDS file open!'
	return
endif
toplevel
;
get_format,format
if format ne 'CHAMELEON' then begin
	print,'***Error(GET_SCANS): format of file is ',format,'!'
	return
endif
;
; Find out about reference station of data
dat_find,'GENCONFIG'
dat_there,'REFSTATION',reply
if reply eq 1 then cmp_get0i,'REFSTATION',refstation else refstation=1
dat_annul
;
get_numscan,NS
if NS lt 1 then begin
	print,'***Error(GET_SCANS): file must have more than one scan!'
	return
endif
;
; Allocate scans
scans=replicate(scan(),NS)
scans.iscan=indgen(NS)+1
;
dat_find,'SCANDATA'
;
; Get miscellaneous one dimensional vectors
cmp_get1c,'STARID',NS,StarId
scans.starid=fixstarids(StarId)
;
dat_there,'STAR',reply
if reply eq 1 then begin
	cmp_get1c,'STAR',NS,stars
	scans.star=stars
endif
;
cmp_get1d,'SCANTIME',NS,times
scans.time=times
if max(abs(times)/3600) gt 24 and max(abs(times)/3600) lt 48 then begin
	genconfig.date=nextdate(geoparms.date)
	!date_change=1	; To be tested as of 2020-07-27
endif else begin
	genconfig.date=geoparms.date
	!date_change=0	; To be tested as of 2020-07-27
endelse
;
dat_there,'INT_TIME',reply
if reply eq 1 then begin
	cmp_get1d,'INT_TIME',NS,int_times
	scans.int_time=int_times
endif
;
name='R0'
dat_there,name,reply
if reply then begin
	cmp_get1r,name,NS,r0
	scans.r0=r0
endif
if total(scans.r0) eq 0 then scans.r0=1	; Default 1" seeing
;
name='PWV'
dat_there,name,reply
if reply then begin
	cmp_get1r,name,NS,pwv
	scans.pwv=pwv
endif
if total(scans.pwv) eq 0 then scans.pwv=10	; Default 10 mm PW column
;
; Now load OUTPUTBEAM, TRIPLE, INPUTBEAM objects
vdim=1L
max_items=100L
num_items=max_items
items=sindgen(num_items)	; This is for a listing of items loaded
for i=0,num_items-1 do items[i]='123456789012345'
for i=0,num_items-1 do items[i]='               '
;
dat_find,'OUTPUTBEAM'
for j=0L,GenConfig.NumOutBeam-1 do begin
	dat_cell,vdim,j+1
	list_names,comp_names
	for k=0,n_elements(comp_names)-1 do begin
		dat_find,comp_names[k]
		if strtrim(comp_names[k]) eq 'VISSQ' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'VisSq dimensions inconsistent '+ $
					'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do begin
				for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].VisSq(j,ic,ib)=reform(v[ic,ib,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'VISSQERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'VisSqErr dimensions inconsistent '+ $
					'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do begin
				for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].VisSqErr(j,ic,ib)=reform(v[ic,ib,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'VISSQC' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'VisSqC dimensions inconsistent '+ $
					'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do begin
				for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].VisSqC(j,ic,ib)=reform(v[ic,ib,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'VISSQCERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'VisSqCErr dimensions inconsistent '+ $
					'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do begin
			    for ic=0,GenConfig.NumSpecChan[j]-1 do $
			    scans[*].VisSqCErr(j,ic,ib)=reform(v[ic,ib,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'VISPHASE' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'VisPhase dimensions inconsistent '+ $
					'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do begin
				for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].VisPhase(j,ic,ib)=reform(v[ic,ib,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'VISPHASEERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'VisPhaseErr dimensions inconsistent '+ $
					'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do begin
				for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].VisPhaseErr(j,ic,ib)=reform(v[ic,ib,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'DIFFPHASE' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'DiffPhase dimensions inconsistent '+ $
					'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do begin
				for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].DiffPhase(j,ic,ib)=reform(v[ic,ib,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'DIFFPHASEERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'DiffPhaseErr dimensions inconsistent '+ $
					'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do begin
				for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].DiffPhaseErr(j,ic,ib)=reform(v[ic,ib,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'DIFFPHASEC' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'DiffPhaseC dimensions inconsistent '+ $
					'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do begin
				for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].DiffPhaseC(j,ic,ib)=reform(v[ic,ib,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'DIFFPHASECERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'DiffPhaseCErr dimensions inconsistent '+ $
					'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do begin
				for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].DiffPhaseCErr(j,ic,ib)=reform(v[ic,ib,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'DELAYJITTER' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				   'DelayJitter dimensions inconsistent '+ $
				   'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do $
			    scans[*].DelayJitter(j,ib)=reform(v[ib,*],NS)
		endif else if strtrim(comp_names[k]) eq 'DELAYJITTERERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				   'DelayJitterErr dimensions inconsistent '+ $
				   'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do $
			    scans[*].DelayJitterErr(j,ib)=reform(v[ib,*],NS)
		endif else if strtrim(comp_names[k]) eq 'TrackRMS' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				   'TrackRMS dimensions inconsistent '+ $
				   'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do $
			    scans[*].TrackRMS(j,ib)=reform(v[ib,*],NS)
		endif else if strtrim(comp_names[k]) eq 'TrackJitter' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne GenConfig.NumBaseline[j] then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				   'TrackJitter dimensions inconsistent '+ $
				   'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,GenConfig.NumBaseline[j]-1 do $
			    scans[*].TrackJitter(j,ib)=reform(v[ib,*],NS)
		endif else if strtrim(comp_names[k]) eq 'PHOTONRATE' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'PhotonRate dimensions inconsistent '+ $
					'with declarations!'
					return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].PhotonRate(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'PHOTONRATEERR' then $
									begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'PhotonRateErr dimensions '+ $
					'inconsistent with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].PhotonRateErr(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'BACKGNDRATE' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'BackGndRate dimensions inconsistent '+ $
					'with declarations!'
					return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].BackGndRate(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'BACKGNDERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne GenConfig.NumSpecChan[j] then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'BackGndErr dimensions inconsistent '+ $
					'with declarations!'
					return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.NumSpecChan[j]-1 do $
				scans[*].BackGndErr(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'UVW' then begin
			dat_shape,ndim,dims
			dat_getnd,ndim,dims,v
			if ndim eq 4 then begin
				for ib=0,GenConfig.NumBaseline[j]-1 do begin
			    	for ic=0,GenConfig.NumSpecChan[j]-1 do begin
					for l=0,2 do scans[*].UVW(j,ic,ib,l)= $
						reform(v[ic,ib,l,*],NS)
			    	endfor
				endfor
			endif else if ndim eq 3 then begin
				for ib=0,GenConfig.NumBaseline[j]-1 do begin
			    	for ic=0,GenConfig.NumSpecChan[j]-1 do begin
					for l=0,2 do scans[*].UVW(j,ic,ib,l)= $
						reform(v[ib,l,*]/GenConfig.Wavelength[ic,j],NS)
			    	endfor
				endfor
			endif else begin
				print,'***Error(GET_SCANS): found '+ $
					'UVW dimensions '+ $
					'inconsistent with declarations!'
				return
			endelse
		endif else begin
;			print,'Warning(GET_SCANS): data type unknown: ', $
;				comp_names(k),'!'
		endelse
		dat_annul
	endfor
	dat_annul
endfor
dat_annul
;
name='TRIPLE'
dat_there,name,reply
if reply then begin
dat_find,name
for j=0L,GenConfig.NumTriple-1 do begin
	dat_cell,vdim,j+1
	list_names,comp_names
	for k=0,n_elements(comp_names)-1 do begin
		dat_find,comp_names[k]
		if strtrim(comp_names[k]) eq 'COMPLTRIPLE' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne 2 then icheck=1
			if dims[1] ne max(GenConfig.NumSpecChan) then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				    'ComplTriple dimensions inconsistent '+ $
				    'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,1 do begin
			  for ic=0,GenConfig.TripleNumChan[j]-1 do $
			  scans[*].ComplTriple(j,ib,ic)=reform(v[ib,ic,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'COMPLTRIPLEERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 3 then icheck=1
			if dims[0] ne 2 then icheck=1
			if dims[1] ne max(GenConfig.NumSpecChan) then icheck=1
			if dims[2] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				    'ComplTripleErr dimensions inconsistent '+ $
				    'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ib=0,1 do begin
			  for ic=0,GenConfig.TripleNumChan[j]-1 do $
			  scans[*].ComplTripleErr(j,ib,ic)=reform(v[ib,ic,*],NS)
			endfor
		endif else if strtrim(comp_names[k]) eq 'TRIPLEAMP' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne max(GenConfig.NumSpecChan) then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				    'TripleAmp dimensions inconsistent '+ $
				    'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.TripleNumChan[j]-1 do $
			  scans[*].TripleAmp(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'TRIPLEAMPERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne max(GenConfig.NumSpecChan) then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				    'TripleAmpErr dimensions inconsistent '+ $
				    'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.TripleNumChan[j]-1 do $
			  scans[*].TripleAmpErr(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'TRIPLEPHASE' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne max(GenConfig.NumSpecChan) then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				    'TriplePhase dimensions inconsistent '+ $
				    'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.TripleNumChan[j]-1 do $
			  scans[*].TriplePhase(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'TRIPLEPHASEERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne max(GenConfig.NumSpecChan) then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				    'TriplePhaseErr dimensions inconsistent '+ $
				    'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.TripleNumChan[j]-1 do $
			  scans[*].TriplePhaseErr(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'TRIPLEAMPC' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne max(GenConfig.NumSpecChan) then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				    'TripleAmpC dimensions inconsistent '+ $
				    'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.TripleNumChan[j]-1 do $
			  scans[*].TripleAmpC(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'TRIPLEAMPCERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne max(GenConfig.NumSpecChan) then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				    'TripleAmpCErr dimensions inconsistent '+ $
				    'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.TripleNumChan[j]-1 do $
			  scans[*].TripleAmpCErr(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'TRIPLEPHASEC' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne max(GenConfig.NumSpecChan) then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				    'TriplePhaseC dimensions inconsistent '+ $
				    'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			for ic=0,GenConfig.TripleNumChan[j]-1 do $
			  scans[*].TriplePhaseC(j,ic)=reform(v[ic,*],NS)
		endif else if strtrim(comp_names[k]) eq 'TRIPLEPHASECERR' then begin
			dat_shape,ndim,dims
			icheck=0
			if ndim ne 2 then icheck=1
			if dims[0] ne max(GenConfig.NumSpecChan) then icheck=1
			if dims[1] ne NS then icheck=1
			if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
				    'TriplePhaseCErr dimensions inconsistent '+ $
				    'with declarations!'
				return
			endif
			dat_getnr,ndim,dims,v
			index=where(finite(v) eq 0,count)
			if count gt 0 then begin
				print,'Warning(GETR_SCANS): TriplePhaseCErr not finite! (fixed)'
				v[index]=-1
			endif
			s=1
;			if date eq '2014-04-17' or date eq '2018-08-26' then s=4
			for ic=0,GenConfig.TripleNumChan[j]-1 do $
			  scans[*].TriplePhaseCErr(j,ic)=reform(v[ic,*],NS)/s
		endif else begin
;			print,'Warning(GET_SCANS): data type unknown: ', $
;				comp_names(k),'!'
		endelse
		dat_annul
	endfor
	dat_annul
endfor
dat_annul
; In some cases, phases flip between -180 and +180 degrees, here we correct this
for j=0L,GenConfig.NumTriple-1 do begin
for k=0,n_elements(scans)-1 do begin
	compltriple=scans[k].compltriple(j,*,*)
	index=where(compltriple[0,0,*] lt 0 and compltriple[0,1,*] lt 0,count)
	if count gt 0 then scans[k].triplephase(j,index)= $
			   scans[k].triplephase(j,index)+2*!pi
endfor
endfor
endif
;
dat_find,'INPUTBEAM'
for j=0L,GenConfig.NumSid-1 do begin
	dat_cell,vdim,j+1
	list_names,comp_names
	for k=0,n_elements(comp_names)-1 do begin
		dat_find,comp_names[k]
		dat_shape,ndim,dims
		icheck=0
		if dims[ndim-1] ne NS then icheck=1
		if icheck eq 1 then begin
			print,'***Error(GET_SCANS): found '+ $
				comp_names[k]+' dimensions inconsistent '+ $
				'with declarations!'
			return
		endif else begin
		dat_type,type & type=strcompress(type,/remove_all)
		dat_get,type,ndim,dims,v
;		case type of
;			'_REAL'  :begin
;				  dat_get1r,NS,v
;				  end
;			'_DOUBLE':begin
;				  dat_get1d,NS,v
;				  end
;			     else:begin
;				  print,'***Error(GET_SCANS): unknown type!'
;				  return
;				  end
;		endcase
		case strcompress(comp_names[k],/remove_all) of
		'FDLPOS'       :scans[*].FDLPos(j)=v
		'FDLPOSERR'    :scans[*].FDLPosErr(j)=v
		'GRPDELAY'     :scans[*].GrpDelay(j)=v
		'GRPDELAYERR'  :scans[*].GrpDelayErr(j)=v
		'DRYDELAY'     :scans[*].DryDelay(j)=v
		'DRYDELAYERR'  :scans[*].DryDelayErr(j)=v
		'WETDELAY'     :scans[*].WetDelay(j)=v
		'WETDELAYERR'  :scans[*].WetDelayErr(j)=v
		'PARX'	       :scans[*].ParX(j)=v
		'PARXERR'      :scans[*].ParXErr(j)=v
		'PARY'	       :scans[*].ParY(j)=v
		'PARYERR'      :scans[*].ParYErr(j)=v
		'PARZ'	       :scans[*].ParZ(j)=v
		'PARZERR'      :scans[*].ParZErr(j)=v
		'METRODELAY'   :scans[*].MetroDelay(j)=v
		'METRODELAYERR':scans[*].MetroDelayErr(j)=v
		'NATJITTER'    :scans[*].NATJitter(j)=v
		'NATJITTERERR' :scans[*].NATJitterErr(j)=v
		'NATCOUNTS'    :scans[*].NATCounts(j)=v
		'NATCOUNTSERR' :scans[*].NATCountsErr(j)=v
		'NATJITTER2'   :scans[*].NATJitter2(j,*)=reform(v,1,2,NS)
		'PHOTOMETRY'   :begin
				icheck=0
				if ndim ne 3 then icheck=1
				if dims[0] ne GenConfig.NumOutBeam then icheck=1
				if dims[2] ne NS then icheck=1
				if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'Photometry dimensions '+ $
					'inconsistent with declarations!'
				return
				endif
				if n_elements(scans) gt 1 and $
					genconfig.numspecchan[0] gt 1 then begin
				scans[*].Photometry(j,*,*) $
					=reform(v,[1,dims[0:2]])
				endif else if n_elements(scans) eq 1 and $
					genconfig.numspecchan[0] gt 1 then begin
				scans.Photometry[j,*,*] $
					=reform(v,[1,dims[0:1]])
				endif else scans.Photometry[j]=reform(v)
				end
		'PHOTOMETRYERR':begin
				icheck=0
				if ndim ne 3 then icheck=1
				if dims[0] ne GenConfig.NumOutBeam then icheck=1
				if dims[2] ne NS then icheck=1
				if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'PhotometryErr dimensions '+ $
					'inconsistent with declarations!'
				return
				endif
				if n_elements(scans) gt 1 and $
					genconfig.numspecchan[0] gt 1 then begin
				scans[*].PhotometryErr(j,*,*) $
					=reform(v,[1,dims[0:2]])
				endif else if n_elements(scans) eq 1 and $
					genconfig.numspecchan[0] gt 1 then begin
				scans.PhotometryErr[j,*,*] $
					=reform(v,[1,dims[0:1]])
				endif else scans.PhotometryErr[j]=reform(v)
				end
		'PHOTOMETRYC'  :begin
				icheck=0
				if ndim ne 3 then icheck=1
				if dims[0] ne GenConfig.NumOutBeam then icheck=1
				if dims[2] ne NS then icheck=1
				if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'PhotometryC dimensions '+ $
					'inconsistent with declarations!'
				return
				endif
				if n_elements(scans) gt 1 and $
					genconfig.numspecchan[0] gt 1 then begin
				scans[*].PhotometryC(j,*,*) $
					=reform(v,[1,dims[0:2]])
				endif else if n_elements(scans) eq 1 and $
					genconfig.numspecchan[0] gt 1 then begin
				scans.PhotometryC[j,*,*] $
					=reform(v,[1,dims[0:1]])
				endif else scans.PhotometryC[j]=reform(v)
				end
		'PHOTOMETRYCERR':begin
				icheck=0
				if ndim ne 3 then icheck=1
				if dims[0] ne GenConfig.NumOutBeam then icheck=1
				if dims[2] ne NS then icheck=1
				if icheck eq 1 then begin
				print,'***Error(GET_SCANS): found '+ $
					'PhotometryCErr dimensions '+ $
					'inconsistent with declarations!'
				return
				endif
				if n_elements(scans) gt 1 and $
					genconfig.numspecchan[0] gt 1 then begin
				scans[*].PhotometryCErr(j,*,*) $
					=reform(v,[1,dims[0:2]])
				endif else if n_elements(scans) eq 1 and $
					genconfig.numspecchan[0] gt 1 then begin
				scans.PhotometryCErr[j,*,*] $
					=reform(v,[1,dims[0:1]])
				endif else scans.PhotometryCErr[j]=reform(v)
				end
			else   :begin
;			        print,'Warning(GET_SCANS): '+ $
;				'data type unknown: ',comp_names(k),'!'
			        end
		endcase
		endelse
		dat_annul
	endfor
	dat_annul
endfor
toplevel
;
; Re-reference "pos" data, if necessary (should not happen w/Version 8)
if GenConfig.refstation gt GenConfig.NumSid then begin
	print,'Warning(GET_SCANS): reference station changed to ' $
		+string(refstation,format='(i1)')+'!'
	GenConfig.RefStation=refstation
endif
if GenConfig.refstation ne refstation then begin
	NewStation=GenConfig.refstation
	GenConfig.refstation=refstation
	referencestation,GenConfig.StationId[NewStation-1],'scan'
endif
;
; Apply deadtime correction
; deadcorr
;
print,'Scans loaded.'
;
end
