pro get_scantable
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Create scan table. If no HDS file open, create from scan data.
; Note that since the advent of the 6-way configuration, the number
; of participating (i.e. light contributing) stations may change
; from scan to scan. Therefore, we store in the scantable a logical
; index for each station specifying whether or not this station
; was putting light onto the detector. This information is currently
; (2001/2) not available in the data files, and therefore is added manually
; using the fixconfiguration procedure.
;
common Tables,ScanTable,BGTable,StationTable
common NPOI,npoi_cat,npoi_hip
common Mark3,mark3_baselines,mark3_configs,mark3_cat,mark3_bsc
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if hds_state() eq 0 then begin
	format='AMOEBA'
	NumScan=n_elements(scans)
endif else begin
	toplevel
	get_format,format
	get_numscan,NumScan
endelse
;
if NumScan eq 0 then begin
	print,'***Error(GET_SCANTABLE): no scans!'
	return
endif
MaxSid=9
;
Iscan=lindgen(NumScan)+1	; First scan has ID 1!
NumPoint=lonarr(NumScan)	; Number of data points in a scan
NumCoh=lonarr(NumScan)+1	; Number of 2ms samples in coherent supersample
NumIncoh=lonarr(NumScan)	; Number of supersamples in incoherent int.
Code=lonarr(NumScan)+1		; 1=coherent, 0=incoherent
Station=lonarr(MaxSid,NumScan)+1; 1=station in, 0=station out
;
if format eq 'AMOEBA' then begin
	ScanId=scans.iscan
	StarId=scans.starid
endif else begin
	dat_find,'SCANDATA'
	cmp_get1i,'SCANID',NumScan,ScanId	; ScanId from embedded system
	cmp_get1c,'STARID',NumScan,StarId
	dat_there,'STATION',reply
	if reply eq 1 then begin
		cmp_shape,'STATION',ndim,dims
		cmp_getni,'STATION',ndim,dims,Station
	endif
endelse
;
case format of
'CONSTRICTOR':	begin
	cmp_get1d,'STARTTIME',NumScan,StartTime & StartTime=StartTime/1000
	cmp_get1d,'STOPTIME',NumScan,StopTime & StopTime=StopTime/1000
	cmp_get1i,'NUMPOINT',NumScan,NumPoint
	cmp_get1i,'NUMCOH',NumScan,Numcoh
	cmp_get1i,'NUMINCOH',NumScan,NumIncoh
	cmp_get1i,'CODE',NumScan,Code
	end
'COBRA':	begin
	cmp_get1d,'STARTTIME',NumScan,StartTime & StartTime=StartTime/1000
	cmp_get1d,'STOPTIME',NumScan,StopTime & StopTime=StopTime/1000
	cmp_get1i,'NUMREC',NumScan,NumPoint
	cmp_get1i,'CODE',NumScan,Code
	end
'INCHWORM':	begin
	cmp_get1d,'STARTTIME',NumScan,StartTime & StartTime=StartTime/1000
	cmp_get1d,'STOPTIME',NumScan,StopTime & StopTime=StopTime/1000
	end
'CHAMELEON':	begin
	dat_there,'STARTTIME',reply
	if reply eq 1 then begin
		cmp_get1d,'STARTTIME',NumScan,StartTime
		cmp_get1d,'STOPTIME',NumScan,StopTime
	endif else begin
		cmp_get1d,'SCANTIME',NumScan,ScanTime
		StartTime=abs(ScanTime)
		StopTime=abs(ScanTime)+30
	endelse
;	index=where(StopTime-StartTime eq 0,count)
;	if count gt 0 then StopTime(index)=StartTime(index)+30
	dat_there,'NUMCOH',reply
	if reply eq 1 then cmp_get1i,'NUMCOH',NumScan,NumCoh
	dat_there,'NUMINCOH',reply
	if reply eq 1 then cmp_get1i,'NUMINCOH',NumScan,NumInCoh
	dat_there,'NUMPOINT',reply
	if reply eq 1 then cmp_get1i,'NUMPOINT',NumScan,NumPoint
	dat_there,'CODE',reply
	if reply eq 1 then cmp_get1i,'CODE',NumScan,Code
	end
'AMOEBA':	begin
	StartTime=scans.time
	StopTime=scans.time
	end
endcase
;
if format ne 'AMOEBA' then dat_annul
;
StarId=fixstarids(StarId)
;
ScanTable=build_scantable(Iscan,ScanId,StarId,Code,Station, $
			StartTime,StopTime,NumPoint, $
			NumCoh,NumIncoh)
;
index=where(scantable.numpoint ne 0,count)
if format eq 'CONSTRICTOR' and count lt NumScan then begin
	print,'***Warning(GET_SCANTABLE): some scans without data (fixed)!'
	scantable=scantable[index]
endif
;
if not !qiet then print,'Scantable created.'
;
end
