pro get_sed,sed_file,starid=starid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read a spectrum file to obtain the spectral energy distribution (SED).
; Units are not checked, Jy are recommended, but could also be erg/cm^2/s.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(scans) eq 0 then begin
	print,'Error: no scan data loaded!'
	return
endif
if n_elements(sed_file) eq 0 then sed_file='sed.dat'
sed_file=file_search(sed_file)
if strlen(sed_file) eq 0 then begin
	print,'Error: SED file not found and/or data not loaded!'
	return
endif else begin
	print,'Read spectrum (SED) from file '+sed_file
	status=dc_read_free(sed_file,lamda,flux,/col)
endelse
if status ne 0 then begin
	print,'Error: file reading error!'
	return
endif
if n_elements(startable) gt 1 and not keyword_set(starid) then begin
	print,'Error: please specify StarId!'
	return
endif
;
; Read spectrum if available, single night and target only
for k=0,genconfig.numoutbeam-1 do begin
	nc=genconfig.numspecchan[k]
	w=genconfig.wavelength[0:nc-1,k]
	si=sort(w)
      	for i=0,n_elements(scans)-1 do begin
		scans[i].photometry(0,k,si)=spline(lamda,flux,w[si])
		scans[i].photometryerr(0,k,si)=scans[i].photometry(0,k,si)/10
	endfor
endfor
scans.photometryc=scans.photometry
;
end
