pro get_seeingdata,filename
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read scan averaged seeing data from either .con or .cha file.
; Note that delayjitter and natjitter are point data.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common SeeingData,scintillation,r0,t0,delayrms,phaserms,delayjitter2,natjitter2
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(filename) ne 0 then begin
	hds_open,filename,'READ',status
	if status ne 0 then return
endif
;
for i=0,genconfig.numoutbeam-1 do begin
	get_object,'SCANDATA.OUTPUTBEAM('+string(i+1)+').SCINTILLATION',si
	get_object,'SCANDATA.OUTPUTBEAM('+string(i+1)+').T0',tn
	get_object,'SCANDATA.OUTPUTBEAM('+string(i+1)+').DELAYRMS',dr
;	get_object,'SCANDATA.OUTPUTBEAM('+string(i+1)+').PHASERMS',pr
	get_object,'SCANDATA.OUTPUTBEAM('+string(i+1)+').DELAYJITTER',dj
	if i eq 0 then begin
		r=size(si)
		if r[0] gt 0 then begin
			r[r[0]+2]=r[r[0]+2]*genconfig.numoutbeam
			r=[r[0],genconfig.numoutbeam,r[1:r[0]+2]]
			r[0]=r[0]+1
			scintillation=make_array(size=r,/float)
		endif
		r=size(tn)
		if r[0] gt 0 then begin
			r[r[0]+2]=r[r[0]+2]*genconfig.numoutbeam
			r=[r[0],genconfig.numoutbeam,r[1:r[0]+2]]
			r[0]=r[0]+1
			t0=make_array(size=r,/float)
		endif
;
		r=size(dr)
		if r[0] gt 0 then begin
			r[r[0]+2]=r[r[0]+2]*genconfig.numoutbeam
			r=[r[0],genconfig.numoutbeam,r[1:r[0]+2]]
			r[0]=r[0]+1
			delayrms=make_array(size=r,/float)
		endif
;
		r=size(pr)
		if r[0] gt 0 then begin
			r[r[0]+2]=r[r[0]+2]*genconfig.numoutbeam
			r=[r[0],genconfig.numoutbeam,r[1:r[0]+2]]
			r[0]=r[0]+1
			phaserms=make_array(size=r,/float)
		endif
;
		r=size(dj)
		if r[0] gt 0 then begin
			r[r[0]+2]=r[r[0]+2]*genconfig.numoutbeam
			r=[r[0],genconfig.numoutbeam,r[1:r[0]+2]]
			r[0]=r[0]+1
			delayjitter2=make_array(size=r,/float)
		endif
	endif
	if n_elements(si) ne 0 then scintillation[i,*,*]=si
	if n_elements(tn) ne 0 then t0[i,*,*,*]=tn
	if n_elements(dr) ne 0 then delayrms[i,*,*]=dr
	if n_elements(pr) ne 0 then phaserms[i,*,*]=pr
	if n_elements(dj) ne 0 then delayjitter2[i,*,*]=dj
endfor
;
for i=0,genconfig.numsid-1 do begin
	get_object,'SCANDATA.INPUTBEAM('+string(i+1)+').NATJITTER',aj
	if i eq 0 then begin
                r=size(aj)
		if r[0] gt 0 then begin
                	r[r[0]+2]=r[r[0]+2]*genconfig.numsid
                	r=[r[0],genconfig.numsid,r[1:r[0]+2]]
                	r[0]=r[0]+1
                	natjitter2=make_array(size=r,/float)
		endif
	endif
	if n_elements(aj) ne 0 then natjitter2[i,*,*]=aj
endfor
;
; These four variables are also part of the scans structure
if n_elements(si) ne 0 then scans.si=scintillation
if n_elements(tn) ne 0 then scans.t0=t0
if n_elements(dr) ne 0 then scans.delayrms=delayrms
if n_elements(pr) ne 0 then scans.phaserms=phaserms
if n_elements(dj) ne 0 then scans.delayjitter2=delayjitter2
if n_elements(aj) ne 0 then scans.natjitter2=natjitter2
;
end
