pro get_sky
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read entire Sky Catalogue 2000.0. This catalog is copyright, and unless
; user !owner uses the full version, it will read from the Hipparcos
; catalog instead those HD stars with a HIP ID.
;
common StarBase,StarTable,Notes
;
if getenv('USER') ne !owner then begin
;	This file just has the HDN IDs of the Sky Catalogue 2000
	restore,!catalogs_dir+'skycat/hdn.xdr'
	starids='HDN'+stringl(hdn,format='(i6.6)')
 	create_startable,starids
 	rename_starids,'hdn-hip'
 	index=where(startable.hic ne 0)
 	starids=starids[index]
 	get_startable,startable[index].starid
endif else begin
	hdn=0L
	hdn=lindgen(49418)+1	; Trigger catalog.c to read all records
	starids='HDN'+stringl(hdn,format='(i6.6)')
	get_startable,starids
	hdn=startable.hdn
	save,hdn,filename=!catalogs_dir+'skycat/hdn.xdr'
;	Restore StarId due to sequential read
	startable.starid='HDN'+stringl(startable.hdn,format='(i6.6)')
endelse
;
end
