pro get_standwb
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For stars loaded in StarTable, find them in the catalog of HgMn stars by
; Stickland and Weatherby (by position, precision=2").
;
common StarBase,startable,notes
;
; Read catalog.xdr to startable_sw, if it exists
rmfile=!catalogs_dir+'proprietary/standwb/SandW.xdr'
result=file_search(rmfile)
IF strlen(result[0]) ne 0 THEN restore,rmfile $
			  ELSE BEGIN
;
; Make copy of startable
if n_elements(startable) ne 0 then startable_in=startable
;
; Read catalog data from Renson and Manfroid
l=''
status=dc_read_fixed(!catalogs_dir+'proprietary/standwb/SandW.txt',l,/col, $
	format='(a166)',ignore=['!'])
n=n_elements(l)
create_startable,strarr(n)
;
for i=0,n-1 do begin
	words=nameparse(l[i],'|')
	startable[i].name=words[3]
	startable[i].reference=words[4]
	startable.mv=float(words[8])
	startable.bv=float(words[7])-float(words[8])
	startable[i].spectrum=words[11]
	coords=nameparse(words[5])
	rah=float(coords[0])
	ram=float(coords[1])
	ras=float(coords[2])
	decd=float(coords[3])
	decm=float(coords[4])
	decs=float(coords[5])
	startable[i].ra=rah+ram/60+ras/3600
	startable[i].dec=abs(decd)+decm/60+decs/3600
	if decd lt 0 then startable[i].dec=-startable[i].dec
endfor
startable_sw=startable
save,startable_sw,filename=!catalogs_dir+'proprietary/standwb/SandW.xdr'
;
startable=startable_in
sep=fltarr(n_elements(startable))
;
if 0 then begin
for i=0,n_elements(startable)-1 do $
	sep[i]=min(winkel(startable_sw.ra,startable_sw.dec,$
		startable[i].ra,startable[i].dec)*3600)
	histograph,sep,binsize=0.05,min=0,max=4
endif
;
ENDELSE
;
for i=0,n_elements(startable)-1 do begin
;
sep=winkel(startable_sw.ra,startable_sw.dec,startable[i].ra,startable[i].dec)
index=where(sep*3600 lt 2,n)
if n eq 1 then begin
	print,startable[i].starid+' is in list of Stickland and Weatherby!'
	print,startable[i].spectrum
endif
;
endfor
;
end
