pro get_startable,starids,names=names,ra_in=ra,dec_in=dec,name_in=name, $
	quiet=quiet
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compound procedure to create startable and read catalogs.
; If stars are not specified, assume CHAMELEON is calling this
; procedure and list the stars in the scantable, and also read
; the diameters.
;
; The procedure expects starids like CAT1234, e.g., HDN123456
;
; If names keyword set, store star names.
; If keyword name_in is set, use it to set the name in startable.
; If RA and DEC are specified, just create a single entry:
; 	get_startable,ra='02h33m09.668',dec='+42d53m46.265'
;
common StarBase,StarTable,Notes
;
if keyword_set(ra) and keyword_set(dec) then begin
	print,'Please note: RA [hms or deg] and DEC [dms or deg]'
;	Both h/d and d/d input formats are now allowed.
	ra_in=ra
	dec_in=dec
	if isnumeric(ra) then ra_d=hms(ra_in) else ra_d=ra_in
	if isnumeric(dec) then dec_d=dms(dec_in) else dec_d=dec_in
	create_startable,'',ra_in=ra_d,dec_in=dec_d
	if keyword_set(name) then startable.name=name[0]
;	startable.ra=ra/15	; StarTable RA must be in hours
;	startable.dec=dec
	return
endif
;
; If called without star list, this is a call within data reduction context
if n_params() eq 0 then begin
	list_stars,starids,names
	if starids[0] eq '' then return
endif
;
; Make backup copy
; starids_bck=starids
;
starids=strupcase(starids)
create_startable,starids,/quiet
read_catalogs
;
; Restore input starids for those targets not found
; index=where(startable.ra eq 0 and startable.dec eq 0,count)
; if count gt 0 then startable(index).starid=starids_bck(index)
;
; Read additional info if called within data reduction context without star list
if n_params() eq 0 then begin
;	Get better photometry from Bright Star Catalog
	rename_starids,'fkv-bsc'
	read_catalogs
	rename_bsc
	get_diameter
	get_ubvri
;	Obtain improved astrometry from Hipparcos catalog
	table=StarTable
	rename_starids,'fkv-hic'
	rename_starids,'bsc-hic'
	rename_starids,'hic-hip'
	read_catalogs
	table.ra=StarTable.ra
	table.rae=StarTable.rae
	table.dec=StarTable.dec
	table.dece=StarTable.dece
	table.pmra=StarTable.pmra
	table.pmrae=StarTable.pmrae
	table.pmdec=StarTable.pmdec
	table.pmdece=StarTable.pmdece
	table.px=StarTable.px
	table.pxe=StarTable.pxe
	table.hic=StarTable.hic
	table.starid=starids
	StarTable=table
endif
if keyword_set(names) then StarTable.name=names
;
end
