pro get_stationtable,stnfile,update=update
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; If specified, the input stationfile contains station coordinates and
; constant terms to update the coordinates in GenConfig.
; Data need to be horizon coordinates. Update occurs only if update=1 (default).
;
; If no stationfile is defined, this routine will use files with path info
; and the array configuration to compute the coordinates and constant terms.
;
; Note that if no station file is defined and the system is NPOI or VLTI,
; constant term delay contributions are collected according to the
; specific feed system configuration in the GenConfig object.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(update) eq 0 then update=1 else update=update gt 0
if update then if checkdata([8]) ne 0 then return
;
; If no input defined, set information for config tables
if n_elements(stnfile) eq 0 then begin
   case system_id(SystemId) of
	'PTI'     : stnfile=!oyster_dir+'pti/stations.pti'
	'CHARA'   : stnfile=!oyster_dir+'chara/stations.chara.old'
	'IOTA'    : stnfile=!oyster_dir+'iota/stations.iota'
	'VLTI'    : begin
		    stnfile=!oyster_dir+'vlti/stations.config'
		    telfile=!oyster_dir+'vlti/tel.config'
		    uvwfile=!oyster_dir+'vlti/uvw.config'
		    fdlfile=!oyster_dir+'vlti/fdl.config'
		    m16file=!oyster_dir+'vlti/m16.config'
		    swyfile=!oyster_dir+'vlti/swy.config'
		    end
	'COAST'   : stnfile=!oyster_dir+'coast/stations.coast'
	'Keck'    : stnfile=!oyster_dir+'keck/stations.keck'
	'Mark3'   : stnfile=!oyster_dir+'mark3/stations.mark3'
	'NPOI'    : begin
		    stnfile=!oyster_dir+'npoi/stations.config'
		    fdlfile=!oyster_dir+'npoi/fdl.config'
		    case genconfig.beamcombinerid of
		    	1: wayfile=!oyster_dir+'npoi/3way.config'
		    	2: wayfile=!oyster_dir+'npoi/6way.config'
		    	3: wayfile=!oyster_dir+'npoi/6way.config'
		    	9: wayfile=!oyster_dir+'npoi/6way.config'
		     else: begin
			   print,'***Error(GET_STATIONTABLE): ' $
                                +'unknown beam combiner ID: ', $
				genconfig.beamcombinerid,'!'
		           return
			   end
		    endcase
		    end
	      else: begin
		    print,'***Warning(GET_STATIONTABLE): unknown SystemId: ', $
						SystemId,'!'
		    S=genconfig.stationid
		    X=fltarr(genconfig.numsid)
		    Y=fltarr(genconfig.numsid)
		    Z=fltarr(genconfig.numsid)
		    D=fltarr(genconfig.numsid)
		    StationTable=build_stationtable(S,X,Y,Z,D)
		    return
		    end
   endcase
endif
;
; Check files exist
result=file_search(stnfile,count=fcount)
if fcount eq 0 then begin
	print,'***Error(GET_STATIONTABLE): ',stnfile,' not found!'
	return
endif
;
; NPOI needs additional configuration files
if SystemId eq 'NPOI' and n_params() eq 0 then begin
	result=file_search(fdlfile,count=fcount)
	if fcount eq 0 then begin
		print,'***Error(GET_STATIONTABLE): ',fdlfile,' not found!'
		return
	endif
	result=file_search(wayfile,count=fcount)
	if fcount eq 0 then begin
		print,'***Error(GET_STATIONTABLE): ',wayfile,' not found!'
		return
	endif
endif
; VLTI needs additional configuration files
if system_id(SystemId) eq 'VLTI' and n_params() eq 0 then begin
	result=file_search(telfile,count=fcount)
	if fcount eq 0 then begin
		print,'***Error(GET_STATIONTABLE): ',telfile,' not found!'
		return
	endif
	result=file_search(uvwfile,count=fcount)
	if fcount eq 0 then begin
		print,'***Error(GET_STATIONTABLE): ',uvwfile,' not found!'
		return
	endif
	result=file_search(fdlfile,count=fcount)
	if fcount eq 0 then begin
		print,'***Error(GET_STATIONTABLE): ',fdlfile,' not found!'
		return
	endif
	result=file_search(m16file,count=fcount)
	if fcount eq 0 then begin
		print,'***Error(GET_STATIONTABLE): ',m16file,' not found!'
		return
	endif
	result=file_search(swyfile,count=fcount)
	if fcount eq 0 then begin
		print,'***Error(GET_STATIONTABLE): ',swyfile,' not found!'
		return
	endif
endif
;
; Now read the station file
S=''
X=0.d0
Y=0.d0
Z=0.d0
D=0.d0
DL_ID=0
BC_IN=0
if dc_read_free(stnfile,S,X,Y,Z,D,DL_ID,BC_IN,/col,resize=[1,2,3,4,5],ignore=['!
   ne 0 then begin
   print,'***Error(GET_STATIONTABLE): file, ',stnfile,' corrupt!'
   return
endif
;
; Read additional configuration data for some interferometers for computation
if system_id(SystemId) eq 'NPOI' and n_params() eq 0 then begin
	if dc_read_free(fdlfile,d_id,d_v,/col,ignore=['!']) ne 0 then begin
		print,'***Error(GET_STATIONTABLE): file, ',fdlfile,' corrupt!'
		return
	endif
	d_v=d_v[sort(d_id)]
	if dc_read_free(wayfile,b_id,b_v,/col,ignore=['!']) ne 0 then begin
		print,'***Error(GET_STATIONTABLE): file, ',wayfile,' corrupt!'
		return
	endif
	b_v=b_v[sort(b_id)]
endif
if system_id(SystemId) eq 'VLTI' and n_params() eq 0 then begin
	if dc_read_free(telfile,teltyp,telopl,teldu,teldv,/col,ignore=['!']) $
	ne 0 then begin
		print,'***Error(GET_STATIONTABLE): file, ',telfile,' corrupt!'
		return
	endif
	if dc_read_free(uvwfile,uvwtel,uvwu,uvwv,uvww,/col,ignore=['!']) $
	ne 0 then begin
		print,'***Error(GET_STATIONTABLE): file, ',uvwfile,' corrupt!'
		return
	endif
	if dc_read_free(fdlfile,fdlid,fdlopl,fdlu,fdlvin,fdlvout,/col,ignore=['!']) $
	ne 0 then begin
		print,'***Error(GET_STATIONTABLE): file, ',fdlfile,' corrupt!'
		return
	endif
	fdlopl=fdlopl[sort(fdlid)]
	fdlu=fdlu[sort(fdlid)]
	fdlvin=fdlvin[sort(fdlid)]
	fdlvout=fdlvout[sort(fdlid)]
	if dc_read_free(m16file,m16id,m16u,/col,ignore=['!']) ne 0 then begin
		print,'***Error(GET_STATIONTABLE): file, ',m16file,' corrupt!'
		return
	endif
	m16u=m16u[sort(m16id)]
	if dc_read_free(swyfile,swyid,swyopl,/col,ignore=['!']) ne 0 then begin
		print,'***Error(GET_STATIONTABLE): file, ',swyfile,' corrupt!'
		return
	endif
	swyopl=swyopl[sort(swyid)]
endif
;
; Create stationtable and  reduce table to stations defined in GenConfig.
; Update stationcoord if requested.
StationTable=build_stationtable(S,X,Y,Z,D)
SI=intarr(n_elements(stationtable))
if checkdata([8]) eq 0 then begin
for i=0,GenConfig.NumSid-1 do begin
	index=where(S eq GenConfig.StationId[i],count)
	if count eq 0 then begin
	   print,'***Error(GET_STATIONTABLE): '+ $
		 'station not found in StationTable!'
	   return
	endif
	if update then begin
		GenConfig.StationCoord[0,i]=x[index]
		GenConfig.StationCoord[1,i]=y[index]
		GenConfig.StationCoord[2,i]=z[index]
		GenConfig.StationCoord[3,i]=d[index]
	endif
	SI[index]=1
endfor
stationtable=stationtable[where(SI eq 1)]
endif
;
; Apply additional configuration changes if computed and update if requested
if system_id(SystemId) eq 'NPOI' and n_params() eq 0 and update then begin
	GenConfig.StationCoord[3,0:GenConfig.NumSid-1]= $
	GenConfig.StationCoord[3,0:GenConfig.NumSid-1] $
			+d_v[GenConfig.DelaylineID[0:GenConfig.NumSid-1]-1] $
			+b_v[GenConfig.BCInputId[0:GenConfig.NumSid-1]-1]
endif
;
if system_id(SystemId) eq 'VLTI' and n_params() eq 0 and update then begin
	for i=0,genconfig.numsid-1 do begin
		j=where(teltyp eq strmid(genconfig.stationid[i],0,1)) & j=j[0]
;		OPL M3(pivot)-M11
		opd0=telopl[j]
		k=where(uvwtel eq strmid(genconfig.stationid[i],1,2)) & k=k[0]
;		Add telescope pivot W coordinate
		opd0=opd0+uvww[k]
;		M11 offset to station centre changes sign for a northern station
		if teltyp[j] eq 'A' and uvwv[k] gt -32 then begin
			teldv[j]=-teldv[j]
			teldu[j]=-teldu[j]
		endif
;		Compute M11 V-coordinate
		vm11=uvwv[k]+teldv[j]
;		Compute difference to M12 V-coordinate and add
		if teltyp[j] eq 'U' then $
		opd0=opd0+abs(vm11-fdlvin[genconfig.delaylineid[i]-1])
		if teltyp[j] eq 'A' then $
		opd0=opd0+abs(vm11-fdlvout[genconfig.delaylineid[i]-1])
;		Compute M12 U-coordinate
		um12=uvwu[k]+teldu[j]
;		Compute difference to DL mechanical zero position and add
		opd0=opd0+abs(fdlu[genconfig.delaylineid[i]-1]-um12)
;		Add internal delay of DL
		opd0=opd0+fdlopl[genconfig.delaylineid[i]-1]
;		Add difference in U-coord. to m16 U-coord.
		opd0=opd0+abs(fdlu[genconfig.delaylineid[i]-1] $
				-m16u[genconfig.bcinputid[i]-1])
;		Add difference in V-coord. to reference plane of switch yard
		if teltyp[j] eq 'U' then $
		opd0=opd0+abs(-36.0-fdlvout[genconfig.delaylineid[i]-1])
		if teltyp[j] eq 'A' then $
		opd0=opd0+abs(-36.0-fdlvin[genconfig.delaylineid[i]-1])
;		Add path from switch yard table to ZPD
		opd0=opd0+swyopl[genconfig.bcinputid[i]-1]
;		Store total OPD (i.e. OPD0)
		genconfig.stationcoord[3,i]=opd0
	endfor
endif
;
if update then $
print,'StationTable created; StationCoord updated.' else $
print,'StationTable created.'
;
end
