pro get_stecklum,init=init,update=update
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read MIDI calibrator list, "stecklum.hdn", compiled by consortium.
; HDN.xdr can be updated (update=1) since not all stars in the Stecklum list are
; also in SKYCAT used by OYSTER for HDN starids.
; Diameters are LD.
;
; If a StarTable is present (and init=0), update it with the information found.
; If no Startable is present or init=1, then read entire list and initialize
; a StarTable. If update=1, update hdn.xdr for HDN numbers not found.
;
common StarBase,startable,notes
;
if n_elements(init) eq 0 then init=0
;
if n_elements(startable) eq 0 or init then begin
	status=dc_read_free(!oyster_dir+'starbase/stecklum.hdn',hdn,/col, $
		ignore=['!'])
	get_startable,'HDN'+string(hdn,format='(i6.6)')
	uindex=where(startable.hdn eq 0)
	startable.hdn=hdn
endif
;
index=where(startable.diameter ne 0,diameter_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	hdn=startable[index].hdn
	startable[index].bflag='.'
;
	lines=''
	status=dc_read_fixed(!oyster_dir+'starbase/stecklum.hdn',lines, $
		/col,resize=[1],format='(a800)',ignore=['!'])
	n=n_elements(lines)
	hd=lonarr(n)
	ra=strarr(n)
	dc=strarr(n)
	pr=fltarr(n)
	pd=fltarr(n)
	sp=strarr(n)
	mv=fltarr(n)
	mh=fltarr(n)
	fi=fltarr(n)
	tf=fltarr(n)
	dm=fltarr(n)
	dme=fltarr(n)
	chisq=fltarr(n)
;
	for i=0,n-1 do begin
        hd[i]=long(strcompress(strmid(lines[i],3,6),/remove_all))
        ra[i]=strmid(lines[i],23,2)+':'+strmid(lines[i],26,2)+':'+strmid(lines[i
        dc[i]=strmid(lines[i],49,3)+':'+strmid(lines[i],53,2)+':'+strmid(lines[i
        sp[i]=strmid(lines[i],81,14)
        pr[i]=((float(strmid(lines[i],128,6))/15)*100)/cos(dms2d(dc[i])*!pi/180)
        pd[i]=float(strmid(lines[i],144,6))*100
        mv[i]=float(strmid(lines[i],160,6))
        mhs=strmid(lines[i],176,6)
        if strlen(strcompress(mhs,/remove_all)) gt 1 then mh[i]=float(mhs)
        fis=strmid(lines[i],192,7)
        f12=strmid(lines[i],224,6)
        if strlen(strcompress(fis,/remove_all)) ge 1 then fi[i]=float(fis) $
                                                     else fi[i]=float(f12)
       	tf[i]=float(strmid(lines[i],288,7))
       	dms=strmid(lines[i],320,9)
       	if strlen(strcompress(dms,/remove_all)) gt 1 then dm[i]=float(dms)
       	dmse=strmid(lines[i],336,9)
       	if strlen(strcompress(dmse,/remove_all)) gt 1 then dme[i]=float(dmse)
       	chi2=strmid(lines[i],368,9)
       	if strlen(strcompress(chi2,/remove_all)) gt 1 then chisq[i]=float(chi2)
	endfor
;
	for i=0L,count-1 do begin
		j=where(hd eq hdn[i] and dm gt 0,j_count)
		if j_count gt 0 then begin
			startable[i].ra=hms2h(ra[j])
			startable[i].dec=dms2d(dc[j])
			startable[i].spectrum=sp[j]
			startable[i].pmra=pr[j]
			startable[i].pmdec=pd[j]
			startable[i].diameter=dm[j]
;			startable(i).diametere=dme(j)*dm(j)/100
			startable[i].mh=mh[j]
			startable[i].f12=fi[j]
			startable[i].teff=tf[j]
			startable[i].sflag=string(chisq[j])
			startable[i].bflag='C'
		endif
	endfor
;
	index=where(startable.diameter ne 0,diameter_count2)
	print,'Number of new diameter values found: ', $
		diameter_count2-diameter_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_STECKLUM): No stars with HDN name found!'
;
if init then startable=startable[where(startable.diameter gt 0)]
;
; Make sure integer spectral types and classes are up-to-date
spec_parse
;
; Update HDN.xdr
if n_elements(uindex) ne 0 then begin
	if uindex[0] ne -1 and keyword_set(update) then $
	update_cat,startable[uindex].starid
endif
;
end
