pro get_sysconfig,sysid=sysid,datum=datum,stations=stations
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read all items in the common block SysConfig, i.e. the Date, SystemID,
; GeoParms, and GenConfig from the HDS data file. Compound procedure.
;
; If any of the SysConfig keywords are defined, close HDS file and
; create SysConfig objects from scratch.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
; if keyword_set(sysid) then SystemId=sysid
; if keyword_set(datum) then Date=datum
;
; If sysid and/or datum and stations are supplied, close file and initialize
if keyword_set(sysid) or keyword_set(datum) $
		      or keyword_set(stations) gt 0 then hds_close
;
get_geoparms,sysid,datum
get_genconfig,stations
if checkdata([7,8]) ne 0 then return
;
; Metrology configuration only for NPOI observations (disabled in 2012)
; if SystemId eq 'NPOI' then get_metroconfig,no_alloc=no_alloc
;
; GenConfig.Date is a unique identifier for these observations
genconfig.date=geoparms.date
;
end
