pro get_systemid,sysid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read SystemId. If no HDS file open, set to sysid. Default is NPOI.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if hds_state() eq 0 then begin
	if n_elements(sysid) eq 0 then begin
		print,'Warning(GET_SYSTEMID): SystemId undefined!'
		sysid='NPOI/6way'
		print,'Set SystemId to: ',sysid
	endif
	SystemId=sysid
	return
endif else begin
	toplevel
	cmp_get0c,'SYSTEMID',sysid
	dat_find,'GENCONFIG'
	cmp_get0i,'BEAMCOMBINERID',BeamCombinerId
	sysid=system_id(sysid)+'/' $
	     +instrument_id(sysid,beamcombiner=BeamCombinerId)
	if n_params() eq 0 then SystemId=sysid
	dat_annul
	return
endelse
;
end
