pro get_teff
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read Cayrel de Strobel (1985) effective temperature data in
; catalogs/npoi/teff.hdn.
; Note: data will replace current non-zero values!
;
common StarBase,startable,notes
;
index=where(startable.teff ne 0,teff_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	teff1=startable[index].teff
	hdn=startable[index].hdn
	status=dc_read_free(!oyster_dir+'starbase/teff.hdn', $
		n,teff,/col,ignore=['!'])
;
	for i=0L,count-1 do begin
		j=where(n eq hdn[i],j_count)
		if j_count gt 0 then begin
			teff1[i]=teff[j[0]]
		endif
	endfor
	startable[index].teff=teff1
;
	index=where(startable.teff ne 0,teff_count2)
	print,'Number of new temperature values found: ',teff_count2-teff_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_TEFF): No stars with HDN name found!'
;
end
