pro get_tycho,init=init
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read VT and BT from the Tycho catalog and compute V and (B-V).
; Update the startable, if it exists, or create new one.
; The StarIds are Hipparcos IDs!
;
common StarBase,startable,notes
common get_tycho_local,tycho_data
;
if n_elements(init) eq 0 then init=0
if n_elements(startable) eq 0 then init=1
;
if n_elements(startable) ne 0 then startable_inp=startable
;
; Read Tycho data (some of it...)
tycho_csv=!oyster_dir+'catalogs/tycho/tycho2.csv'
;
tycho_data=read_csv(tycho_csv)
hip=long(tycho_data.field24)
star_ids='HIP'+string(hip,format='(i6.6)')
create_startable,star_ids,/quiet
startable.hic=hip
;
comps=tycho_data.field24
index=where(isnumeric(comps) eq 0,count)
for i=0l,count-1 do begin
	len1=strlen(comps[index[i]])
	len2=strlen(strtrim(string(long(comps[index[i]])),1))
	startable[index[i]].name=strmid(comps[index[i]],len2,len1-len2)
endfor
;
startable.ra=tycho_data.field03/15
startable.dec=tycho_data.field04
startable.pmra=tycho_data.field05*(100./15d3)
startable.pmdec=tycho_data.field06*(100./1d3)
startable.pmrae=tycho_data.field08*(100./15d3)
startable.pmdece=tycho_data.field06*(100./1d3)
btmag=tycho_data.field18
ebtmag=tycho_data.field19
vtmag=tycho_data.field20
evtmag=tycho_data.field21
; http://www.aerith.net/astro/color_conversion.html
; V = VT - 0.090 * (BT - VT)
; B - V = 0.850 * (BT - VT)
startable.mv=vtmag-0.090*(btmag-vtmag)
startable.bv=0.850*(btmag-vtmag)
;
if init then return
;
index=whereequal(startable_inp.hic,startable.hic)
for i=0l,n_elements(index)-1 do begin
	j=where(startable.hic eq startable_inp[index[i]].hic) & j=j[0]
	startable_inp[index[i]].mv=startable[j].mv
	startable_inp[index[i]].bv=startable[j].bv
endfor
;
; Try to find additional matches with the Tycho catalog if HIP ID is missing
;
; Adopted positional precision of catalog
min_sep=dblarr(n_elements(startable_inp))
precision=5.0	; ["]
;
for i=0l,n_elements(startable_inp)-1 do begin
	sep=winkel(startable.ra,startable.dec, $
		   startable_inp[i].ra,startable_inp[i].dec)*3600
	min_sep[i]=min(sep)
	if min_sep[i] le precision then begin
		j=where(sep eq min_sep[i]) & j=j[0]
		startable_inp[i].mv=startable[j].mv
		startable_inp[i].bv=startable[j].bv
	endif
endfor
; The histogramm shows that the precision is about 4"
histograph,min_sep,binsize=0.5,min=0,max=10
;
end
