pro get_vanbelle,init=init,update=update
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read PTI calibrator list courtesy of Gerard van Belle (et al. 2008, ApJS, 176)
; Diameters are LD.
;
; If a StarTable is present (and init=0), update it with the information found.
; If no Startable is present or init=1, then read entire list and initialize
; a StarTable. If update=1, update hdn.xdr for HDN numbers not found.
;
common StarBase,startable,notes
;
if n_elements(init) eq 0 then init=0
;
if n_elements(startable) eq 0 or init then begin
	status=dc_read_free(!oyster_dir+'starbase/vanbelle.hdn',hdn,/col, $
		ignore=['!'])
	get_startable,'HDN'+string(hdn,format='(i6.6)')
	uindex=where(startable.hdn eq 0)
	startable.hdn=hdn
endif
;
index=where(startable.diameter ne 0,diameter_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	hdn=startable[index].hdn
	startable[index].bflag='.'
;
	sp=''
	vmag=''
	status=dc_read_free(!oyster_dir+'starbase/vanbelle.hdn', $
		hd,rah,ram,ras,decd,decm,decs,pmra,pmdec,plx,d,e,spectra,vmag, $
		/col,ignore=['!'])
;
	for i=0L,count-1 do begin
	j=where(hd eq hdn[i],j_count)
	if j_count eq 1 then begin
		startable[i].ra=double(rah[j])+double(ram[j])/60+ras[j]/3600
		startable[i].dec=double(decd[j])+double(decm[j])/60+decs[j]/3600
		startable[i].pmra=((pmra[j]*100)/15)/cos(startable[i].dec*!pi/180)
		startable[i].pmdec=pmdec[j]*100
		startable[i].px=plx[j]
		startable[i].diameter=d[j]
;		startable(i).diametere=e(j)
		startable[i].spectrum=spectra[j]
		startable[i].mv=float(strmid(vmag[j],2,5))
		startable[i].bflag='C'
	endif
	endfor
;
	index=where(startable.diameter ne 0,diameter_count2)
	print,'Number of new diameters added: ', $
		diameter_count2-diameter_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_VANBELLE): No stars with HDN name found!'
;
; Make sure integer spectral types and classes are up-to-date
spec_parse
;
; Update HDN.xdr
if n_elements(uindex) ne 0 then begin
	if uindex[0] ne -1 and keyword_set(update) then $
	update_cat,startable[uindex].starid
endif
;
end
