pro get_verhoelst,init=init,update=update
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read MIDI calibrator list, "verhoelst.hdn", compiled by Tijl Verhoelst
; (Thesis). HDN.xdr can be updated (update=1) since not all stars in the
; Verhoelst list are also in SKYCAT used by OYSTER for HDN starids.
;
; All quality flags except those related to TF are included and if any is set,
; slfag is set to 2, otherwise 1. TF accuracy criterion is relaxed to 5%.
;
; Diameters are LD.
;
; If a StarTable is present (and init=0), update it with the information found.
; If no Startable is present or init=1, then read entire list and initialize
; a StarTable. If update=1, update hdn.xdr for HDN numbers not found.
;
common StarBase,startable,notes
;
if n_elements(init) eq 0 then init=0
;
if n_elements(startable) eq 0 or init then begin
	status=dc_read_free(!oyster_dir+'starbase/verhoelst.hdn',hdn,/col, $
		ignore=['!'])
	get_startable,'HDN'+string(hdn,format='(i6.6)')
	uindex=where(startable.hdn eq 0)
	startable.hdn=hdn
	t=startable
	rename_starids,'hdn-hip'
	read_catalogs
	pmra=startable.pmra
	pmdec=startable.pmdec
	startable=t
	startable.pmra=pmra
	startable.pmdec=pmdec
endif
;
index=where(startable.diameter ne 0,diameter_count1)
;
index=where(startable.hdn ne 0,count)
if count gt 0 then begin
	hdn=startable[index].hdn
	startable[index].bflag='.'
;
	lines=''
	status=dc_read_fixed(!oyster_dir+'starbase/verhoelst.hdn',lines, $
		/col,resize=[1],format='(a800)',ignore=['!'])
	n=n_elements(lines)
	hd=lonarr(n)
	ra=strarr(n)
	dc=strarr(n)
	pr=fltarr(n)
	pd=fltarr(n)
	px=fltarr(n)
	pe=fltarr(n)
	sp=strarr(n)
	mb=fltarr(n)
	mv=fltarr(n)
	mj=fltarr(n)
	mh=fltarr(n)
	mk=fltarr(n)
	fi=fltarr(n)
	tf=fltarr(n)
	dm=fltarr(n)
	dme=fltarr(n)
	chisq=fltarr(n)
	flag14=strarr(n)
	flag15=strarr(n)
	flag16=strarr(n)
	flag17=strarr(n)
	flag18=strarr(n)
	flag19a=strarr(n)
	flag19b=strarr(n)
	flag19c=strarr(n)
	flag19d=strarr(n)
	origin=strarr(n)
;
	for i=0,n-1 do begin
       	hd[i]=long(strcompress(strmid(lines[i],0,6),/remove_all))
       	ra[i]=strmid(lines[i],8,2)+':'+strmid(lines[i],11,2)+':'+strmid(lines[i]
       	dc[i]=strmid(lines[i],21,3)+':'+strmid(lines[i],25,2)+':'+strmid(lines[i
       	pr[i]=((float(strmid(lines[i],34,6))/15)*100)/cos(dms2d(dc[i])*!pi/180)
       	pd[i]=float(strmid(lines[i],41,6))*100
	pxs=strmid(lines[i],67,6)
	if strlen(strcompress(pxs,/remove_all)) gt 1 then px[i]=float(pxs)/1000
	pes=strmid(lines[i],76,6)
	if strlen(strcompress(pes,/remove_all)) gt 1 then pe[i]=float(pes)/1000
       	sp[i]=strmid(lines[i],49,14)
       	mbs=strmid(lines[i],101,6)
       	if strlen(strcompress(mbs,/remove_all)) gt 1 then mb[i]=float(mbs)
       	mvs=strmid(lines[i],116,6)
       	if strlen(strcompress(mvs,/remove_all)) gt 1 then mv[i]=float(mvs)
       	mjs=strmid(lines[i],148,6)
       	if strlen(strcompress(mjs,/remove_all)) gt 1 then mj[i]=float(mjs)
       	mhs=strmid(lines[i],163,6)
       	if strlen(strcompress(mhs,/remove_all)) gt 1 then mh[i]=float(mhs)
       	mks=strmid(lines[i],178,6)
       	if strlen(strcompress(mks,/remove_all)) gt 1 then mk[i]=float(mks)
       	fis=strmid(lines[i],210,5)
       	if strlen(strcompress(fis,/remove_all)) ge 1 then fi[i]=float(fis)
	origin[i]=strmid(lines[i],224,1)
	if origin[i] eq 'M' then fi[i]=fi[i]*1.4	; MSX is color corrected
       	tf[i]=float(strmid(lines[i],231,5))
	dm[i]=float(strmid(lines[i],251,6))
	dme[i]=float(strmid(lines[i],260,5))
       	chisq[i]=strmid(lines[i],280,6)
	flag14[i]=strmid(lines[i],293,1)
	flag15[i]=strmid(lines[i],297,1)
	flag16[i]=strmid(lines[i],301,1)
	flag17[i]=strmid(lines[i],305,1)
	flag18[i]=strmid(lines[i],309,1)
	flag19a[i]=strmid(lines[i],315,1)
	flag19b[i]=strmid(lines[i],319,1)
	flag19c[i]=strmid(lines[i],323,1)
	flag19d[i]=strmid(lines[i],327,1)
	endfor
;
	for i=0L,count-1 do begin
	j=where(hd eq hdn[i],j_count)
	if j_count gt 0 then begin
		startable[i].ra=hms2h(ra[j])
		startable[i].dec=dms2d(dc[j])
		startable[i].spectrum=sp[j]
;		startable(i).pmra=pr(j)
;		startable(i).pmdec=pd(j)
		startable[i].px=px[j]
		startable[i].pxe=pe[j]
		startable[i].diameter=dm[j]
;		startable(i).diametere=dme(j)
		startable[i].mj=mj[j]
		startable[i].mh=mh[j]
		startable[i].mk=mk[j]
		startable[i].f12=fi[j]
		startable[i].teff=tf[j]
		startable[i].model='LDN'
		sflag=strjoin([flag14[j],flag15[j],flag16[j],flag17[j],flag18[j]])
		if strlen(strcompress(sflag,/remove_all)) eq 0 then sflag='1' $
							       else sflag='2'
		if viscalerror(dm[j],dme[j],bl=100.0,wl=10e-6) gt 5 then sflag='2'
		startable[i].sflag=sflag
		startable[i].bflag='C'
;		startable(i).reference=origin(j)
	endif
	endfor
;
	index=where(startable.diameter ne 0,diameter_count2)
	print,'Number of new diameter values found: ', $
		diameter_count2-diameter_count1,'.', $
		format='(a,i4,a)'
;
endif else print,'Warning(GET_VERHOELST): No stars with HDN name found!'
;
; Make sure integer spectral types and classes are up-to-date
spec_parse
;
; Update HDN.xdr
if n_elements(uindex) ne 0 then begin
	if uindex[0] ne -1 and keyword_set(update) then $
	update_cat,startable[uindex].starid
endif
;
end
