pro get_vincidata,fitsfile
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; In the VINCI pipeline, the FITS data get written in vndrs_FITS.c
; Currently obsolete.
;
; Notes on VLTI/VINCI configuration
;
;     W
;	   N				J6
;               E			|
;	      			UT3     J5
;     S          			|
;					|
;               UT2			J4
;					|
;					J3	UT4
;
;
;     UT1
;			Lab
;		       123456  Channel (BC Input ID)
; ------------------------|-----------------------------
;			 M16
;
;               M12->                       	DL1
;               M12->                       	DL2
; DL3				<-M12
; DL4				<-M12
;	M12->					DL5
;	M12->					DL6
; DL7				<-M12
; DL8				<-M12
; -------------------------|----------------------------
; A0 B0 C0  D0  E0   G0         H0          K0 L0 M0
; |  |  |   |
; A1 B1 C1  |
;    B2 C2  |                           J1
;    B3 C3  D1				|
;    B4     |                       I1  |
;    B5     D2                          J2
;
;                    G1
;
; VINCI light path: M1 (alt-az), M2 (fixed), M3-M4 (compressor), M5 (feed), M12
; UT Coude path   : M1 (8m), M2 (tip-tilt, controlled by STRAP), M3 (folding to
;		    Nasmyth A), M4 (folding to Coude train), M5,6,7 (Coude),
;		    M8 (deformable, controlled by MACAO), M9 (dichroic),
;		    M10 (movable), M12
; Guide star at Nasmyth focus has 2' FOV, 20 Hz servo loop;
; with MACAO 0.2 Hz loop for out-of-range error signal prevention
;
; Re-imaging of pupil with UTs: M2, M8, center of tunnel, beam compr., MIDI
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common ModelFit,parameters,ds_options
;
ob=vinci_of_read[fitsfile]
ffl=obj_new('fitsFileList',fitsfile)
;
; SystemId
kvt=ffl->getHeaderKeys('instrume')
SystemId=strcompress(kvt.instrume,/remove_all)
systemid='VLTI'
;
; Date
kvt=ffl->getHeaderKeys('date-obs')
date=strmid(kvt.dateobs,0,10)
;
; Get geoparms
get_geoparms
;
; Read file
ob=vinci_of_read[ffl->files()]
;
; For reference
; cn=ob.source_table->columnnames()
;
; Allocate GenConfig
MaxSid=2
MaxOut=2
MaxTriple=10
MaxBase=6
Maxchan=16
MaxConfig=10
genconfig=allocgenconfig(MaxSid,MaxOut,MaxTriple,MaxBase,MaxChan,MaxConfig)
genconfig.date=date
;
; Station IDs
sids=ob.geom_data.sta_name
numsid=n_elements(sids)
stationids=strarr(numsid)+'V  '
for i=0,numsid-1 do begin
	name=stationids[i]
	if strmid(sids[i],0,1) eq 'U' $
		then strput,name,strcompress(sids[i],/remove),0 $
		else strput,name,strcompress(sids[i],/remove),1
	stationids[i]=name
endfor
genconfig.stationid[0:numsid-1]=stationids
genconfig.numsid=numsid
;
; Station coordinates
genconfig.stationcoord[0:2,0:numsid-1]=ob.geom_data.staxyz
;
; Other general configuration data
genconfig.refstation=1
genconfig.delaylineid[0:numsid-1]=ob.ot_data.dly_line
genconfig.bcinputid[0:numsid-1]=ob.ot_data.lab_beam
genconfig.wavelength[0,0]=2.2/1.d6
genconfig.chanwidth[0,0]=0.1/1.d6
genconfig.numspecchan=1
genconfig.numoutbeam=1
genconfig.numbaseline=1
genconfig.baselineid[0,0]=genconfig.stationid[1]+'-'+genconfig.stationid[0]
;
; Stars
stars=strtrim(reform(ob.source_data.source),2)
starids=stars
hic=cri(stars,'HIC')
for i=0,n_elements(stars)-1 do begin
	hic_id=0L
	update=0
	if hic[i] le 0 then begin
		read,hic_id, $
		prompt='Please enter Hipparcos number for '+stars[i]+': '
		update=1
	endif else hic_id=hic[i]
	hic[i]=hic_id
	star_id=string(hic[i],format='(i6.6)')
	if update then $
		spawn,'echo "'+star_id+' '+stars[i]+'" >> ' $
		+!oyster_dir+'starbase/vlti.hic'
	starids[i]='HIP'+star_id
endfor
get_startable,starids
startable.name=stars
;
; Number of scans (batches)
num_scan=ob.nbatch
scans=replicate(scan(),num_scan)
;
ut_days=reform(ob.batches.batch_data.time)
scans.time=(ut_days-long(ut_days))*86400
if scans[0].time gt scans[num_scan-1].time then begin
	index=where(scans.time lt scans[0].time)
	scans[index].time=scans[index].time+86400
	genconfig.date=nextdate(geoparms.date)
endif else genconfig.date=geoparms.date
scans.starid=startable[reform(ob.batches.batch_data.source)-1].starid
;
; Visibility squared first interferometric channel
scans.vissq=reform(ob.batches.batch_data.mu12,(size(scans.vissqc))[1:4])
scans.vissqerr=reform(ob.batches.batch_data.emu12,(size(scans.vissqc))[1:4])
;
; Visibility squared second interferometric channel
; scans.vissq=ob.batches.batch_data.mu22
; scans.vissqerr=ob.batches.batch_data.emu22
;
; Initialize calibrated visibility
scans.vissqc=scans.vissq
scans.vissqcerr=scans.vissqerr
;
; To access batch data
; batch=*ob.batches[0].scan_data
;
; Photometric channels A and B
scans.natcounts=reform(ob.batches.batch_data.photom)
scans.natcountserr=reform(ob.batches.batch_data.photomsd)
;
; Standard deviation of OPD
scans.delayjitter=reform(ob.batches.batch_data.sdopd,(size(scans.delayjitter))[1
scans.delayjittererr=1e-6
;
; uvw
scans[*].uvw(*)=ob.batches.batch_data.uvw/genconfig.wavelength[0]
;
; OPD power spectrum moments
; ob.batches.batch_data.corpower(0) ; integrated power
; ob.batches.batch_data.corpower(1) ; position of the spectral peak (meters)
; ob.batches.batch_data.corpower(2) ; width of the spectral peak (meters)
;
; Create scantable
Iscan=lindgen(num_scan)+1       ; Attention: First scan has ID 1!
ScanId=lindgen(num_scan)        ; ScanId of embedded system
StartTime=scans.time
StopTime=scans.time
NumCoh=lonarr(num_scan)+1
NumIncoh=lonarr(num_scan)+1
NumPoint=reform(ob.batches.batch_data.nscan)
StarId=scans.starid
Code=lonarr(num_scan)+1
Station=lonarr(NumSid,Num_Scan)+1       ; 1=station in, 0=station out
;
ScanTable=build_scantable(Iscan,ScanId,StarId,Code,Station, $
                        StartTime,StopTime,NumPoint, $
                        NumCoh,NumIncoh)
;
print,'Scantable created.'
;
get_startable
get_stationtable
get_geoparms
calcastrom
;
obj_destroy,ob.prihead
obj_destroy,ob.source_table
obj_destroy,ob.ot_table
obj_destroy,ob.geom_table
obj_destroy,ob.batch_table
obj_destroy,ob.fringe_a_table
obj_destroy,ffl
;
freememory
GenInfo=replicate(GenConfig,1)
GeoInfo=replicate(GeoParms,1)
;
if n_elements(ds_options) eq 0 then ds_options=alloc_ds_options()
ds_options.i=1  ; True: interferometry loaded
ds_options.v2=1
ds_options.ta=0
ds_options.tp=0
;
end
