pro get_wbs,init=init,tycho=tycho
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read entire WDS bible into startable. If init=1, read text file and save as
; xdr file. Only in this case, if tycho=1, match coordinates with Tycho catalog
; and extract V and (B-V) values.
;
common StarBase,StarTable,Notes
;
RAD=180/!pi
;
wbs_file='wds/wdsweb_summ.txt'
xdr_file='wds/wdsweb_summ.xdr'
;
if keyword_set(tycho) then begin
	tycho_csv=!oyster_dir+'catalogs/tycho/tycho2.csv'
	tycho_data=read_csv(tycho_csv)
	tycho_hip=long(tycho_data.field24)
	tycho_ra=tycho_data.field03/15
	tycho_dec=tycho_data.field04
	tycho_mv=tycho_data.field20 $
		-0.090*(tycho_data.field18-tycho_data.field20)
	tycho_bv=0.850*(tycho_data.field18-tycho_data.field20)
	precision=2.0	; ["]
endif
;
file=file_search(!catalogs_dir+xdr_file)
;
if strlen(file) eq 0 or keyword_set(init) then begin
;
l=''
status=dc_read_fixed(!catalogs_dir+wbs_file,l,/col,format='(a130)')
;
; Remove the 2 header lines
l=l[2:n_elements(l)-1]
;
; Extract data lines
coord_info=strmid(l,118,1)+strmid(l,121,1)+strmid(l,128,1)
index=where(coord_info eq '.-.' or coord_info eq '.+.',n)
l=l[index]
names=strarr(n)
ra=dblarr(n)
dec=dblarr(n)
a=fltarr(n)
mv=fltarr(n)+100
bv=fltarr(n)+100
dm=fltarr(n)+100
s=strarr(n)
starid=strarr(n)
wds=lonarr(n)
hip=lonarr(n)
;
min_sep=dblarr(n)+1e9
bad_entries=intarr(n)
;
for i=0l,n-1 do begin
	wds[i]=long(strmid(l[i],5,1)+strmid(l[i],0,5)+strmid(l[i],6,4))
	names[i]=strcompress(strmid(l[i],10,9),/remove_all)
	bad_entries[i]=1
	if strlen(strcompress(strmid(l[i],112,6),/remove_all)) ne 0 and $
	   strlen(strcompress(strmid(l[i],126,4),/remove_all)) eq 4 then begin
		bad_entries[i]=0
		ra[i]=double(strmid(l[i],112,2)) $
		     +double(strmid(l[i],114,2))/60 $
		     +double(strmid(l[i],116,5))/3600
		dec[i]=double(strmid(l[i],122,2)) $
		      +double(strmid(l[i],124,2))/60 $
		      +double(strmid(l[i],126,4))/3600
		if strmid(l[i],121,1) eq '-' then sign=-1 else sign=1
		dec[i]=sign*dec[i]
	endif
	starid[i]='WDS'+strmid(l[i],5,1)+strmid(l[i],0,5)+strmid(l[i],6,4)
	starid[i]='WDS'+strmid(l[i],0,10)
	if strlen(strcompress(strmid(l[i],52,5),/remove_all)) gt 1 then $
	a[i]=float(strmid(l[i],52,5))
	if strlen(strcompress(strmid(l[i],58,5),/remove_all)) gt 1 then $
	mv[i]=float(strmid(l[i],58,5))
	if strlen(strcompress(strmid(l[i],64,5),/remove_all)) gt 1 then begin
		mb=float(strmid(l[i],64,5))
;		If both mags available, compute combined and magn. difference
		if mv[i] ne 100 then begin
			dm[i]=mb-mv[i]
			mv[i]=cmag(mv[i],mb)
		endif
	endif
	s[i]=strmid(l[i],70,8)
;	Tycho
	if keyword_set(tycho) and bad_entries[i] eq 0 then begin
		sep=winkel(tycho_ra,tycho_dec,ra[i],dec[i])*3600
		min_sep[i]=min(sep)
		if min_sep[i] le precision then begin
			j=where(sep eq min_sep[i]) & j=j[0]
			hip[i]=tycho_hip[j]
			mv[i]=tycho_mv[j]
			bv[i]=tycho_bv[j]
		endif
	endif
endfor
;
; The histogramm shows that the precision is about 2"
; minsep=min_sep(where(min_sep lt 1e9))
; histograph,min_sep,binsize=0.05,min=0,max=2
;
create_startable,starid
startable.name=names
startable.ra=ra
startable.dec=dec
startable.mv=mv
startable.bv=bv
startable.dmv=dm
startable.spectrum=s
startable.a=a
startable.wds=wds
startable.hic=hip
;
startable=startable[where(bad_entries eq 0)]
;
; Remove some "suspicious" entries
index=where(startable.a gt 0,count)
if count gt 0 then startable=startable[index]
index=where(startable.a ne 999.9,count)
if count gt 0 then startable=startable[index]
;
save,startable,file=!catalogs_dir+xdr_file
;
endif else begin
;
restore,!catalogs_dir+xdr_file
;
endelse
;
end
