pro get_wdlinedata,opslog
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read a file, e.g., wdline.2005-03-01.ops.log and create data with precise
; delays for OPD model fitting.
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
l=''
status=dc_read_fixed(opslog,l,/col,format='(a300)')
index=where(strpos(l,'POM MEASURE') ge 0 and strpos(l,'J 2000') ge 0,count)
if count eq 0 then begin
	print,'***Error(GET_WDLINEDATA): no POM data'
	return
endif
l=l[index]
n=count
;
ra=fltarr(n)
dec=fltarr(n)
configs=strarr(n)
dates=strarr(n)
times=fltarr(n)
delay=fltarr(n,2)
;
for k=0,n-1 do begin
	i0=strpos(l[k],'MEASURE')
	i1=strpos(l[k],'/')
	command=strmid(l[k],i0,i1-i0)
	r=execute(command)
	w=nameparse(measure)
	configs[k]=strmid(w[0],0,23)
	ra[k]=float(w[1])+float(w[2])/60+float(w[3])/3600
	dec[k]=abs(float(w[4]))+float(w[5])/60+float(w[6])/3600
	if strmid(w[4],0,1) eq '-' then dec[k]=-dec[k]
	dates[k]=w[13]+'-'+w[14]+'-'+w[15]
	times[k]=float(w[16])+float(w[17])/60+float(w[18])/3600
	delay[k,0]=float(w[19])	; Delay of dl1
	delay[k,1]=float(w[20])	; Delay of dl2
endfor
;
index=where(strpos(configs,'-dl') ge 0,count)
if count eq 0 then begin
	print,'***Error(GET_WDLINEDATA): no valid configurations found!'
	return
endif
configs=configs[index]
uconfigs=unique(configs)
print,'Found configurations: ',uconfigs
num_config=n_elements(uconfigs)
;
starids0='OBJ'+esoid(ra,dec)
hdn=cri(starids0,'hdn')
hdu=unique(hdn)
; Only if all targets have an HD number, read that catalog
index=where(hdu eq -1,count)
if count eq 0 then starids='HDN'+string(hdu,format='(i6.6)') $
	      else starids=unique(starids0)
get_startable,starids
index=where(hdu gt 0,count)
if count gt 0 then startable[index].hdn=hdu[index]
; Our HD catalog does not have good positions, so copy (ra,dec) from ops.log
for i=0,n_elements(startable)-1 do begin
	if startable[i].hdn gt 0 then begin
		index=where(hdn eq startable[i].hdn)
		starids0[index]=startable[i].starid
		startable[i].ra=ra[index[0]]
		startable[i].dec=dec[index[0]]
	endif
endfor
initialized=0
;
FOR iconf=0,num_config-1 DO BEGIN
;
config=uconfigs[iconf]
;
; UTs and ATs generate different config strings
dl1=fix(strmid(config,2,1))
dl2=fix(strmid(config,2+12,1))
ic1=fix(strmid(config,10,1))
ic2=fix(strmid(config,10+12,1))
if strmid(config,3,1) eq 'U' then begin
	s1=strmid(config,3,3)
	s2=strmid(config,15,3)
endif else begin
	s1=strmid(config,3,1)+strmid(config,6,2)
	s2=strmid(config,15,1)+strmid(config,18,2)
endelse
;
index=where(configs eq config,count_obs)
starids1=starids0[index]
dates1=dates[index]
times1=times[index]
delay1=delay[index,*]
date=unique(dates1)
if n_elements(date) gt 1 then begin
	date=date[0]
	index=where(times1 lt 12,count)
	if count gt 0 then times1[index]=times1[index]+24
endif
get_sysconfig,sysid='VLTI/VINCI-MONA'
scans=replicate(scan(),count_obs)
;
scans.starid=starids1
scans.star=starids1
scans.time=times1*3600
scans.fdlpos[0]=delay1[*,0]
scans.fdlpos[1]=delay1[*,1]
scans.fdlposerr=1e-6
;
genconfig.configid=config
genconfig.refstation=1
genconfig.numsid=2
genconfig.stationid[0]=s1
genconfig.stationid[1]=s2
genconfig.numbaseline=1
genconfig.baselineid=s1+'-'+s2
genconfig.delaylineid[0]=dl1
genconfig.delaylineid[1]=dl2
genconfig.bcinputid[0]=ic1
genconfig.bcinputid[1]=ic2
;
if max(abs(scans.time/3600)) gt 24 and max(abs(scans.time/3600)) lt 48 $
	      then genconfig.date=nextdate(geoparms.date) $
	      else genconfig.date=geoparms.date
;
if genconfig.refstation eq 1 $
	then scans.fdlpos[1]=scans.fdlpos[1]-scans.fdlpos[0] $
	else scans.fdlpos[0]=scans.fdlpos[0]-scans.fdlpos[1]
get_scantable
get_stationtable
calcastrom
;
; Initialization for AMOEBA
if not initialized then begin
        freememory
        bufferinfo=replicate(nightinfo(),num_config)
        geoinfo=replicate(geoparms,num_config)
        geninfo=replicate(allocgenconfig(/geninfo),num_config)
        geninfo.configid=uconfigs
        initialized=1
endif
confignum=where(geninfo.configid eq config)
g=geninfo[confignum]
struct_assign,genconfig,g
geninfo[confignum]=g
geoinfo[confignum]=geoparms
storenight
;
ENDFOR
;
end
