pro get_wds,starids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Note: this procedure accesses the WDS orbit catalog with the new SQL format.
;
; Allocate startable and read orbital element data from WDS orbit solution file.
; Read the orbital element data from the "Sixth Catalog of Orbits of
; Visual Binary Stars" by W.I. Hartkopf and B.D. Mason, USNO.
; The file is !catalogs_dir/wds/orb6orbits.txt, and can by downloaded from
; http://www.usno.navy.mil/USNO/astrometry/optical-IR-prod/wds/orb6
; or directly at http://ad.usno.navy.mil/wds/orb6/orb6orbits.txt
; Delete file orb6orbits.xdr to have this procedure re-create it.
;
; This procedure uses or prepares an XDR file for faster access.
; Set startable with data from requested stars.
;
common StarBase,StarTable,Notes
;
RAD=180/!pi
;
; Read wdsorb.xdr, if it exists
; This file contains all orbits calculcated
; orbfile=!catalogs_dir+'wds/orb6master.xdr'
; This file contains only the "official" orbits
orbfile=!catalogs_dir+'wds/orb6orbits.xdr'
result=file_search(orbfile)
IF strlen(result[0]) ne 0 THEN restore,orbfile $
			  ELSE BEGIN
;
IF 0 THEN BEGIN
; This file no longer needed, EQNX is in orb6master.txt
; Read orb6ephem.txt
;
;0000000000000000000000000000000000000000000000000000000000000000000000000000000
;0000000000111111111122222222223333333333444444444455555555556666666666777777777
;0123456789012345678901234567890123456789012345678901234567890123456789012345678
;00014+3937  HLD  60       4  Hei1963a  2000 1961 1960-85    173.9  1.191   173.
;
rec=''
status=dc_read_fixed(!catalogs_dir+'wds/orb6ephem.txt',rec,/col, $
        resize=[1],format='(a142)',ignore=['!'])
num_ephem=n_elements(rec)
wds1=strmid(rec,0,10)
equinx_string=strmid(rec,223,4)
index=where(equinx_string eq '    ',count)
if count gt 0 then equinx_string[index]='   0'
equinx=double(equinx_string)
index=where(equinx eq 0,count)
if count gt 0 then equinx[index]=2000
ENDIF
;
; Read orb6orbits.txt
;
; New 2013 format
;0000000000000000000000000000000000000000000000000000000000000000000000000000000
;0000000011111111112222222222333333333344444444445555555555666666666677777777778
;2345678901234567890123456789012345678901234567890123456789012345678901234567890
; RA,Dec (J2000).. WDS....... DD............ ADS.. HD.... HIP...  V1.11* V2.22*
;
rec=''
status=dc_read_fixed(!catalogs_dir+'wds/orb6orbits.txt',rec,/col, $
	resize=[1],format='(a264)')
num_orbit=n_elements(rec)
IF 0 THEN BEGIN
if num_orbit ne num_ephem then begin
	print,'***Error(GET_WDS): files corrupt?'
	return
endif
ENDIF
;
; Remove blank lines
index=where(strlen(strcompress(rec,/remove_all)) ne 0) & rec=rec[index]
; Extract data lines
coord_info=strmid(rec,6,1)+strmid(rec,9,1)+strmid(rec,16,1)
index=where(coord_info eq '.-.' or coord_info eq '.+.',num_orbit) & rec=rec[inde
; Remove records with missing data (.) in various fields
index=where(strcompress(strmid(rec,58,6),/remove_all) ne '.',num_orbit) & rec=re
index=where(strcompress(strmid(rec,81,11),/remove_all) ne '.',num_orbit) & rec=r
index=where(strcompress(strmid(rec,205,8),/remove_all) ne '.',num_orbit) & rec=r
index=where(strcompress(strmid(rec,125,8),/remove_all) ne '.',num_orbit) & rec=r
index=where(strcompress(strmid(rec,105,9),/remove_all) ne '.',num_orbit) & rec=r
index=where(strcompress(strmid(rec,143,8),/remove_all) ne '.',num_orbit) & rec=r
index=where(strcompress(strmid(rec,162,12),/remove_all) ne '.',num_orbit) & rec=
index=where(strcompress(strmid(rec,187,8),/remove_all) ne '.',num_orbit) & rec=r
;
; Decode the data
;
wds2=strmid(rec,19,10)
wds_string='WDS'+wds2
wds=long(strmid(rec,19,5)+strmid(rec,25,4))
index=where(strmid(rec,24,1) eq '-')
sign=strarr(n_elements(rec))
sign[*]='+'
sign[index]='-'
wdsstarids='WDS'+sign+stringl(wds,format='(i9.9)')
wds[index]=-wds[index]
;
hic_string=strcompress(strmid(rec,58,6),/remove_all)
index=where(hic_string eq '.',count)
if count gt 0 then hic_string[index]='0'
hic=long(hic_string)
hdn_string=strcompress(strmid(rec,51,6),/remove_all)
index=where(hdn_string eq '.',count)
if count gt 0 then hdn_string[index]='0'
hdn=long(hdn_string)
; hdn=cri(hic,'hic-hdn') > 0
;
rah=double(strmid(rec,0,2))
ram=double(strmid(rec,2,2))
ras=double(strmid(rec,4,5))
ra=rah+ram/60+ras/3600
;
decd=double(strmid(rec,10,2))
decm=double(strmid(rec,12,2))
decs_string=strmid(rec,14,4)
; index=where(strlen(strcompress(decs_string,/remove_all)) eq 0,count)
; if count gt 0 then decs_string(index)='0'
decs=double(decs_string)
dec=decd+decm/60+decs/3600
index=where(strmid(rec,9,1) eq '-',count)
if count gt 0 then dec[index]=-dec[index]
;
ads_string=strcompress(strmid(rec,45,5),/remove_all)
; index=where(strlen(ads_string) eq 0,count)
index=where(ads_string eq '.',count)
if count gt 0 then ads_string[index]='0'
ads=long(ads_string)
;
mag_string=strcompress(strmid(rec,66,5),/remove_all)
; index=where(strlen(mag_string) eq 0,count)
index=where(mag_string eq '.',count)
if count gt 0 then mag_string[index]='+100'
index=where(strpos(mag_string,'var') ne -1,count)
if count gt 0 then mag_string[index]='+100'
ma=double(mag_string)
;
mag_string=strcompress(strmid(rec,73,5),/remove_all)
; index=where(strlen(mag_string) eq 0,count)
index=where(mag_string eq '.',count)
if count gt 0 then mag_string[index]='+100'
index=where(strpos(mag_string,'var') ne -1,count)
if count gt 0 then mag_string[index]='+100'
mb=double(mag_string)
;
dmv=mb-ma
index=where(ma gt 99 or mb gt 99,count)
if count gt 0 then dmv[index]=100
;
; Period [d]
period=double(strmid(rec,80,12))
u=strmid(rec,92,1)
index=where(u eq 'y',count)
if count gt 0 then period[index]=period[index]*365.25
index=where(u eq 'c',count)
if count gt 0 then period[index]=period[index]*365.25*100.
; Period error [d]
err_string=strcompress(strmid(rec,94,10),/remove_all)
index=where(err_string eq '.',count)
if count gt 0 then err_string[index]='0'
period_err=double(err_string)
index=where(u eq 'y',count)
if count gt 0 then period_err[index]=period_err[index]*365.25
index=where(u eq 'c',count)
if count gt 0 then period_err[index]=period_err[index]*365.25*100.
; Semimajor axis ["]
amajor=double(strmid(rec,105,9))			; arc seconds
u=strmid(rec,114,1)
index=where(u eq 'm',count)
if count gt 0 then amajor[index]=amajor[index]/1000.	; mas -> arcsec
; Semi-major axis error [d]
err_string=strcompress(strmid(rec,116,8),/remove_all)
index=where(err_string eq '.',count)
if count gt 0 then err_string[index]='0'
smaxis_err=double(err_string)
index=where(u eq 'm',count)
if count gt 0 then smaxis_err[index]=smaxis_err[index]/1000.
; Inclination [deg]
inclin=double(strmid(rec,125,8))		; degrees
; Ascending node [deg]
ascnod=double(strmid(rec,143,8)) & ascnod=precess_pa(ascnod/RAD,equinx,ra,dec,1)
; Epoch
epochp=double(strmid(rec,162,12))
u=strmid(rec,174,1)
index=where(u eq 'y',count)
if count gt 0 then epochp[index]=by2jd(epochp[index])
index=where(u eq 'd',count)
if count gt 0 then epochp[index]=epochp[index]+2400000.0
; epoch_jd=lonarr(num_orbit)
; for i=0,num_orbit-1 do epoch_jd(i)=julian(long(epochp(i)),1,1)
; years=intarr(num_orbit)+365
; index=where(((long(epochp) mod 4) eq 0) and ((long(epochp) mod 400) ne 0),coun
; if count gt 0 then years(index)=366
; epoch_jd=epoch_jd+(epochp mod 1)*years
eccent=double(strmid(rec,187,8))
argper=double(strmid(rec,205,8))
equinx_string=strmid(rec,223,4)
index=where(equinx_string eq '    ',count)
if count gt 0 then equinx_string[index]='   0'
equinx=double(equinx_string)
index=where(equinx eq 0,count)
if count gt 0 then equinx[index]=2000
name=strmid(rec,30,11)
;
; Grade
grade=strmid(rec,233,1)
; Reference
ref=strmid(rec,237,7)
;
create_startable,'HIP'+string(hic,format='(i6.6)')
read_catalogs
StarTable.starid=wds_string
StarTable.name=strcompress(name)
StarTable.bflag='B'
StarTable.ra=ra
StarTable.dec=dec
StarTable.ads=ads
StarTable.wds=wds
StarTable.hic=hic
StarTable.hdn=hdn
;
StarTable.mv=cmag(ma,mb)
StarTable.dmv=dmv
StarTable.p=period
StarTable.a=amajor
StarTable.i=inclin
StarTable.n=ascnod
StarTable.t=epochp
StarTable.e=eccent
StarTable.o=argper
;
StarTable.sflag=grade
StarTable.reference=ref
;
; Plot for GAIA 2017
;index=where(period_err ne 0)
;p=period(index)
;pe=period_err(index)
;!x.style=1
;!x.title='log(period/d)'
;!y.title='Fractional period error'
;!p.title='Orbits in the WDS'
;!p.charsize=1.5
;plot,alog10(p),pe/p,psym=1,yrange=[0,0.3],xrange=[1,7]
;
; index=where(smaxis_err ne 0)
; a=amajor(index)*1000
; ae=smaxis_err(index)
; !x.style=1
; !x.title='log(semi-major axis/mas)'
; !y.title='Fractional error'
; !p.title='Orbits in the WDS'
; !p.charsize=1.5
; plot,alog10(a),ae/a,psym=1,yrange=[0,0.5],xrange=[-3,1]
; !y.title='Error [mas]'
; plot,alog10(a),ae*1000,psym=1,yrange=[0,30],xrange=[0,4]
;
; Remove entries corresponding to photocenter orbits
index=where(strcompress(StarTable.reference,/remove_all) ne 'Ren2013')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'Jnc2005')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'HIP1997')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'Pbx2000')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'Pbx2013')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'Trr2011')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'Gln2007')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'SaJ2013')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'AST2011')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'AST2016')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'AST2007')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'HaI2002')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'Ald1939')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'Ald1925')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'WaX2015')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'Hor2015')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'Fek2015')
StarTable=StarTable[index]
index=where(strcompress(StarTable.reference,/remove_all) ne 'Dru1995')
StarTable=StarTable[index]
;
; Save this catalog to an XDR file
; save,StarTable,filename=!catalogs_dir+'wds/orb6master.xdr'
save,StarTable,filename=!catalogs_dir+'wds/orb6orbits.xdr'
;
ENDELSE
;
n=n_elements(starids)
if n ne 0 then begin
	index=lonarr(n)-1
	m=0
	for i=0,n-1 do begin
		k=where(startable.starid eq starids[i],l)
		if l gt 1 then index=[index,-1]
		if l gt 0 then index[i+m:i+m+l-1]=k
		if l gt 1 then m=m+1
	endfor
	jndex=where(index eq -1,count)
	for i=0,count-1 do print,'Star not found: ',starids[jndex[i]]
	jndex=where(index ge 0,count)
	if count gt 0 then begin
		index=index[jndex]
		startable=startable[index]
	endif
endif
;
end
