pro get_wdsbsc
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Prepare crossindex tables for WDS numbers by comparing the position
; extracted from these numbers to the HR catalog position.
; A separation of less than 100" is considered a match.
;
common StarBase,StarTable,Notes
;
get_bsc
n=StarTable.starid
r=StarTable.ra
d=StarTable.dec
;
get_wds
;
for i=0,n_elements(StarTable)-1 do begin
	sep=sqrt(((StarTable[i].ra-r)*3600*15)^2+((StarTable[i].dec-d)*3600)^2)
	j=where(sep lt 100,count)
	if count gt 0 then begin
		j=where(min(sep) eq sep)
		StarTable[i].bsc=long(strmid(n[j[0]],3,4))
	endif
endfor
;
index=where((StarTable.bsc ne 0) and (StarTable.wds ne 0),count)
wds=StarTable[index].wds
bsc=StarTable[index].bsc
create_cri,'wds-bsc',wds,bsc
;
end
