pro get_wdshdn
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Prepare crossindex tables for WDS numbers by comparing the position
; extracted from these numbers to the HD catalog position (obtained from Yale
; Parallax catalog). A separation of less than 100" is considered a match.
;
common StarBase,StarTable,Notes
;
; Read Vizier-prepared SAO/HD catalog with J2000 positions
sao=0L
hdn=0L
rah=0d
ram=0d
ras=0d
decd=0d
decm=0d
decs=0d
status=dc_read_free(!catalogs_dir+'hdn/catalog.dat', $
	sao,hdn,rah,ram,ras,decd,decm,decs,/col,resize=[1,2,3,4,5,6,7,8], $
	ignore=['#'])
; Decode sign of declination
l=blanks(39)
status=dc_read_fixed(!catalogs_dir+'hdn/catalog.dat',l,/col,format='(a39)', $
	ignore=['#'])
sign=strmid(l,27,1)
index=where(sign eq '-')
decm[index]=-decm[index]
decs[index]=-decs[index]
;
ra=rah+ram/60+ras/3600
dec=decd+decm/60+decs/3600
;
get_wbs		; read the bible
;
; Adopted positional precision of catalog
min_sep=dblarr(n_elements(StarTable))
precision=5 ; ["]
;
for i=0l,n_elements(StarTable)-1 do begin
	sep=winkel(ra,dec,startable[i].ra,startable[i].dec)*3600
	min_sep[i]=min(sep)
	if min_sep[i] le precision then begin
		j=where(sep eq min_sep[i])
		StarTable[i].hdn=hdn[j]
	endif
endfor
; The histogramm shows that the precision is between 5"-6"
; histograph,min_sep,binsize=0.5,min=0,max=10
;
index=where((StarTable.hdn ne 0) and (StarTable.wds ne 0),count)
wds=StarTable[index].wds
hdn=StarTable[index].hdn
create_cri,'wds-hdn',wds,hdn
;
end
