pro get_wise,k_max=ks_max
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read W1 mag. (~=flp) from CatWise and W3 mag. (~=f12) from AllWISE.
; Note: data found will replace current values in StarTable!
;
; For applications which limit K, specifiying the limit here is faster.
; At this time, we equate K and Ks with one another.
;
; Example
; ra='07:32:09.8'
; dec='-16:58:12.654'
; get_startable,ra=ra,dec=dec
;
common StarBase,startable,notes
;
if n_elements(startable) eq 0 then begin
	print,'Error: please create StarTable for your target first!'
	return
endif
;
; Load the first survey data
file=!oyster_dir+'starbase/WISE/allwise/allwise.sam.xdr'
files=file_search(file) & file=files[0]
if strlen(files[0]) eq 0 then begin
	file=!oyster_dir+'starbase/WISE/allwise/allwise.sam'
	status=dc_read_fixed(file,rec,/col,ignore=['#'], $
		resize=[1],format='(a553)')
	allwise=strmid(rec,0,19)	; obj ID
	raj2000=double(strmid(rec,21,10))	; degrees
	dej2000=double(strmid(rec,33,10))	; degrees
	w1mag=float(strmid(rec,67,5))		; W1 magnitude (3.35 micron)
	w2mag=float(strmid(rec,74,5))		; W2 magnitude (4.6  micron)
	w3mag=float(strmid(rec,81,5))		; W3 magnitude (11.6 micron) *
	w4mag=float(strmid(rec,88,5))		; W4 magnitude (22.1 micron)
	jmag=fltarr(n_elements(rec))
	index=where(strlen(strcompress(strmid(rec,95,5),/remove_all)) gt 0)
	jmag[index]=float(strmid(rec[index],95,5))
	hmag=fltarr(n_elements(rec))
	index=where(strlen(strcompress(strmid(rec,102,5),/remove_all)) gt 0)
	hmag[index]=float(strmid(rec[index],102,5))
	ksmag=fltarr(n_elements(rec))
	index=where(strlen(strcompress(strmid(rec,109,5),/remove_all)) gt 0)
	ksmag[index]=float(strmid(rec[index],109,5))
	save,allwise,raj2000,dej2000,w1mag,w2mag,w3mag,w4mag, $
		jmag,hmag,ksmag,file=file+'.xdr'
endif else restore,files[0]
;
; Apply K-band limit, if specified
if n_elements(ks_max) eq 0 then ks_max=max(ksmag)
index=where(ksmag le ks_max,count)
if count eq 0 then begin
	print,'No targets found brighter than K-limit!'
	return
endif
if count lt n_elements(ra) then begin
	raj2000=raj2000[index]
	dej2000=dej2000[index]
	w1mag=w1mag[index]
	w3mag=w3mag[index]
	jmag=jmag[index]
	hmag=hmag[index]
	ksmag=ksmag[index]
endif
;
; Update data in the StarTable with those found in AllWise
;
precision=5.0		; ["]
dh=360./24.
;
for i=0l,n_elements(startable)-1 do begin
	sep=winkel(raj2000*dh,dej2000,startable[i].ra,startable[i].dec)*3600
	index=where(sep eq min(sep))
	if sep[index] le precision then begin
		startable[i].flp=w12jy(w1[j])	; convert W1 mag to Jy
		startable[i].f12=w32jy(w3[j])	; convert W3 mag to Jy
		startable[i].mj=jmag[j]
		startable[i].mh=hmag[j]
		startable[i].mk=kmag[j]
	endif
endfor
;
; Load the data from the second survey
;
file=!oyster_dir+'starbase/WISE/catwise/catwise.sam.xdr'
files=file_search(file) & file=files[0]
if strlen(files[0]) eq 0 then begin
	file=!oyster_dir+'starbase/WISE/catwise/catwise.sam'
	status=dc_read_fixed(file,rec,/col,ignore=['#'], $
		resize=[1],format='(a571)')
	catwise=strmid(rec,0,18)	; obj ID
	raj2000=double(strmid(rec,20,10))
	dej2000=double(strmid(rec,32,10))
	w1mag=float(strmid(rec,318,6))		; W1 magnitude (3.35 micron) *
	w2mag=float(strmid(rec,341,6))		; W2 magnitude (4.6  micron)
	save,catwise,raj2000,dej2000,w1mag,w2mag,file=file+'.xdr'
endif else restore,files[0]
;
; Update the data of allwise with those of catwise (W1 only, W3 if not av.)
;
precision=5.0		; ["]
;
for i=0l,n_elements(startable)-1 do begin
	sep=winkel(raj2000*dh,dej2000,startable[i].ra,startable[i].dec)*3600
	index=where(sep eq min(sep))
	if sep[index] le precision then begin
		startable[i].flp=w12jy(w1mag[j])	; convert W1 mag to Jy
		if startable[i].f12 eq 0 then $
		startable[i].f12=w32jy(w3mag[j])	; convert W3 mag to Jy
	endif
endfor
;
ra_h=ra_deg/15	; -> RA in hours
dec_d=dec_deg
;
; Adopted a positional precision of the catalog coordinates
precision=5.0		; ["]
precision=2000.0	; ["] for testing
min_sep=dblarr(n_elements(startable))
;
index=where(startable.f12 gt 0,f12_count1)
;
for i=0,n_elements(startable)-1 do begin
	sep=winkel(ra_h,dec_d,startable[i].ra,startable[i].dec)*3600 ; arc-sec
;	Sort by separation
	si=sort(sep)
	sep=sep[si]
	ra_h=ra_h[si]
	dec_d=dec_d[si]
	min_sep[i]=min(sep)
	if min_sep[i] le precision then begin
		j=where(sep eq min_sep[i])
		startable[i].flp=w12jy(w1[j])	; convert W1 mag to Jy
		startable[i].f12=w32jy(w3[j])	; convert W3 mag to Jy
		startable[i].mj=jmag[j]
		startable[i].mh=hmag[j]
		startable[i].mk=kmag[j]
	endif
endfor
; The histogramm shows that the precision is about 4" (tbc)
; histograph,min_sep,binsize=0.5,min=0,max=10
;
index=where(startable.f12 gt 0,f12_count2)
print,'Number of new WISE values found: ',f12_count2-f12_count1,'.', $
	format='(a,i5,a)'
;
end
