pro get_xdr,filename,freememory=freememory
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Workaround for systems where HDS cannot be installed. Write these data
; with put_xdr.
;
common Hds,path,hds_file_stub
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common ModelFit,parameters,ds_options
;
if n_elements(filename) eq 0 then begin
	print,'***Error(GET_XDR): no file specified!'
	return
endif
;
restore,filename
;
; This variable is used for naming the HDS output if needed
hds_file_stub=basename(filename)
;
; The genconfig structure might have changed
g=genconfig
GenConfig=allocGenConfig(genconfig.numsid, $
                         genconfig.numoutbeam, $
                         n_elements(genconfig.triplenumchan), $
                         n_elements(genconfig.baselineid[*,0]), $
                         n_elements(genconfig.wavelength[*,0]), $
                         n_elements(genconfig.config))
if genconfig.numsid ne n_elements(g.numsid) $
or genconfig.numoutbeam ne n_elements(g.numbaseline) then begin
	struct_assign,g,genconfig
endif else begin
	tagnames=tag_names(genconfig)
	for i=0,n_tags(genconfig)-1 do begin
		j=where(tag_names(g) eq tagnames[i],count)
		if count eq 1 then genconfig.(i)=g.(j)
	endfor
endelse
genconfig.diameter=system_config(system_id(systemid),'DIAMETER', $
	stations=genconfig.stationid[0])
;
; Store a copy of GenConfig in GenInfo after clearing it, for use in AMOEBA
; if n_elements(GenInfo) le 1 then GenInfo=replicate(GenConfig,1)
;
; Store a copy of GeoParms in GeoInfo after clearing it, for use in AMOEBA
; if n_elements(GeoInfo) le 1 then GeoInfo=replicate(GeoParms,1)
;
; The scans structure might have changed
s=scans
scans=replicate(scan(),n_elements(scans))
tagnames=tag_names(scans)
for i=0,n_tags(scans)-1 do begin
	j=where(tag_names(s) eq tagnames[i],count)
	if count eq 1 then scans.(i)=s.(j)
endfor
;
; The startable is also restored, but the format might have changed
t=startable
create_startable,t.starid
tagnames=tag_names(startable)
for i=0,n_tags(startable)-1 do begin
	j=where(tag_names(t) eq tagnames[i],count)
	if count eq 1 then startable.(i)=t.(j)
endfor
;
; Remove entries in startable which are not found in scans
ustarids=unique(scans.starid)
index=whereequal(startable.starid,ustarids)
startable=startable[index]
;
; Default is to clear AMOEBA's data buffer and store this night's data
if n_elements(freememory) eq 0 then freememory=1
if freememory then begin
	freememory
	GenInfo=replicate(GenConfig,1)
	GeoInfo=replicate(GeoParms,1)
endif
;
if n_elements(ds_options) eq 0 then ds_options=alloc_ds_options()
ds_options.i=1	; True: interferometry loaded
ds_options.v2=1
ds_options.ta=1
ds_options.tp=1
;
end
