pro getcorr,corr_xyz,corr_del,stationcoords,times=times,file=file
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; stationcoords=[[genconfig.stationcoord],[genconfig.stationcoord],....]
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if Date eq '1999-04-10' then times=[28.4,31.5,34.8]*3600d0
if Date eq '1999-04-09' then times=[27.8,31.5,34.6]*3600d0
;
if n_elements(stationcoords) eq 0 or keyword_set(file) then begin
	x=0.d0
	y=0.d0
	z=0.d0
	c=0.d0
	status=dc_read_free(file,x,y,z,c,/col)
	stationcoords=dblarr(4,n_elements(x))
	stationcoords[0,*]=x
	stationcoords[1,*]=y
	stationcoords[2,*]=z
	stationcoords[3,*]=c
endif
;
num_epoch=n_elements(stationcoords[0,*])/3
num_sid=3
;
corr_xyz=reform(stationcoords[0:2,*],3,num_sid,num_epoch)
corr_del=reform(stationcoords[3,*],num_sid,num_epoch)
;
for i=0,num_epoch-1 do begin
	corr_xyz[*,*,i]=stationcoords[0:2,indgen(num_sid)+i*num_sid] $
		       -stationcoords[0:2,indgen(num_sid)]
	corr_del[*,i]=stationcoords[3,indgen(num_sid)+i*num_sid] $
		     -stationcoords[3,indgen(num_sid)]
endfor
;
corr_xyz=+corr_xyz*1d6
corr_del=-corr_del*1d6
;
end
