function gitter,num_steps,value_min,value_max
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return an equally spaced array of values centered on zero, i.e.
; beginning at -value_max and ending at +value_max.
;
if n_params() eq 2 then value_max=-value_min
value_step=(value_max-value_min)/(num_steps-1)
return,dindgen(num_steps)*value_step+value_min
;
end
