pro gordon
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Related to function teff_vmk in that it computes a new set of coefficients
; by including the work by Gordon et al. 2018 on O-star colors and T_eff's.
;
; Not currently in use to derive T_eff from V-K (flat T dependence of V-K)
;
status=dc_read_free(!oyster_dir+'starbase/vmk_teff.dat', $
	HR,dots,constellation,v,vr,vk,flux,SpT,LC,t,e,/col,ignore=['!'])
t=double(t)	; Teff
e=double(e)	; sigma(Teff)
;
si=sort(t)
si=sort(vk)
plot,t[si],vk[si],psym=4,ytitle='(V-K)',xtitle='T_eff [K]'
oplot,teff_vmk(vk[si]),vk[si],psym=0
;
r=poly_fit(vk,t,3)
;
end
