pro gridchisq_parallel,num_grid,grid_cell,component=component,files=files_in, $
	chi2map=chi2map
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Multi-processor wrapper of gridchisq.
;
; Must specify files (CHA format).
; If keyword chi2map is set, num_grid=100 and grid_cell=cb/200 are used.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common OysterBridge,obd
;
; Setup for gridchisq
;
if n_elements(binary_model) eq 0 then begin
	modelfile=''
	read,modelfile,prompt='Please enter name of model file: '
	readmodel,modelfile
endif
if n_elements(component) eq 0 and num_binary() gt 1 then begin
	component=''
	read,component,prompt='Please enter component (e.g. A-B): '
endif
if n_elements(component) ne 0 then k=where(binary_model.component eq component)$
			      else k=0
component=binary_model[k].component
;
if keyword_set(chi2map) then begin
	print,'Parameters for use with chi2map requested!'
	cb=cleanbeam(dirtybeam(gen_model.starid))
	grid_cell=cb[1]/200
	num_grid=160
	print,'Will use num_grid',num_grid,' and grid_cell ',grid_cell
endif
;
if n_elements(num_grid) eq 0 then num_grid=100L else num_grid=long(num_grid)
if n_elements(grid_cell) eq 0 then grid_cell=0.5
;
print,'Grid cell [mas]: ',grid_cell
print,'Size of search box [mas]: ',num_grid*grid_cell
;
if n_elements(files_in) ne 0 then begin
	all_files=file_search(files_in)
	if strlen(all_files[0]) eq 0 then begin
		print,'GRIDFIT: Files not found!'
		return
	endif
	n=n_elements(all_files)
endif else begin
	print,'No files specified!'
	return
endelse
;
; Determine size of each data set
m=fltarr(n)
for i=0,n-1 do begin
;	get_data,all_files(i)
	if extname(all_files[i]) eq 'cha' then get_data,all_files[i]
	if extname(all_files[i]) eq 'fits' then get_oifits,all_files[i]
	r=modelchisq(nfree)
	m[i]=nfree
	if extname(all_files[i]) eq 'cha' then hds_close
endfor
;
; Re-order files by size and interleaf biggest with smallest to reduce load
si=sort(m)
m=m[si]
all_files=all_files[si]
index_s=indgen(n/2+(n mod 2))
index_b=indgen(n/2)+n/2+(n mod 2)
index=intarr(n)
index[indgen(n/2+(n mod 2))*2]=index_s
index[indgen(n/2)*2+1]=reverse(index_b)
all_files=all_files[index]
m=m[index]
;
; Resources: number of CPUs used (n_cpu) and files per CPU (nf_cpu)
ncpu=!cpu.hw_ncpu < 16	; limit due to IDL error when destroying bridge objects
nf_cpu=nint(float(n)/ncpu) > 1			; Number of files per CPU (tbc)
if ncpu*nf_cpu lt n then nf_cpu=nf_cpu+1	; Add 1 file/CPU if needed
n_cpu=n/nf_cpu < ncpu 				; Number of CPU used (tbc)
if n mod nf_cpu gt 0 then n_cpu=n_cpu+1		; Add one CPU if needed
nf_cpu_last=n mod nf_cpu 			; Files processed by last CPU
print,'       Files,         CPU,  files/CPU, CPU req., files (last CPU)'
print,n,ncpu,nf_cpu,n_cpu,nf_cpu_last
;
; Swap biggest file to last CPU if it has fewer files to process
if nf_cpu_last gt 0 and nf_cpu_last lt (nf_cpu-1) then begin
	m_big=m[1]
	m[1]=m[n-1]
	m[n-1]=m_big
	file_big=all_files[1]
	all_files[1]=all_files[n-1]
	all_files[n-1]=file_big
endif
a_files=strarr(nf_cpu+1,n_cpu)
n_files=intarr(n_cpu)
m_files=fltarr(n_cpu)
for j=0,n_cpu-1 do begin
;	if j*nf_cpu gt n-1 then break
	f=unique(all_files[(j*nf_cpu)<(n-1):((j+1)*nf_cpu-1)<(n-1)])
	n_files[j]=n_elements(f)
	a_files[0:n_files[j]-1,j]=f
	index=whereequal(all_files,[f,''])
	m_files[j]=total(m[index])
endfor
print,'Number of measurements to compute per CPU:'
for j=0,n_cpu-1 do print,'CPU'+string(j+1,format='(i2.2)')+':',m_files[j]
;
; Setup OYSTER bridge objects
;
spawn,'pwd',local_dir & local_dir=local_dir[0]
oyster_bridge=objarr(n_cpu)
oyster_bridge_data=strarr(n_cpu)
for j=0,n_cpu-1 do begin
	oyster_bridge[j]=obj_new('IDL_IDLBridge')
	oyster_bridge[j]->execute,".run "+!oyster_dir+"bridge.pro"
	oyster_bridge[j]->execute,"bridge"
	oyster_bridge[j]->execute,"cd,'"+local_dir+"'"
	oyster_bridge_data[j]='bridge_data'+string(j+1,format='(i2.2)')+'.xdr'
	oyster_bridge[j]->setvar,"obd",oyster_bridge_data[j]
endfor
;
; Call gridchisq, n=number of all_files, nf_cpu=number of files per cpu
for j=0,n_cpu-1 do begin
;	if j*nf_cpu gt n-1 then break
;	files=unique(all_files((j*nf_cpu)<(n-1):((j+1)*nf_cpu-1)<(n-1)))
	files=a_files[0:n_files[j]-1,j]
	if n_elements(files) eq 1 then files=files[0]
	save,gen_model,star_model,binary_model, $
		component,files, $
		file=oyster_bridge_data[j]
	parms=string(num_grid)+","+ $
	      string(grid_cell)
	oyster_bridge[j]->execute,"gridchisq,"+parms,/nowait
endfor
;
; Stay in while loop until all processes finish.
notdone = 1
while (notdone ge 1) do begin
	notdone=0
	for j=0,n_elements(oyster_bridge)-1 do $
		notdone = notdone+oyster_bridge[j]->Status()
endwhile
;
print,''
print,'Cleaning up processes...'
for j=0,n_cpu-1 do begin
;	if (oyster_bridge(j)->status() eq 1) then oyster_bridge(j)->abort
	obj_destroy,oyster_bridge[j]
	spawn,'rm -f '+oyster_bridge_data[j]
endfor
;
end
