pro gridpipe,chafiles
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Run gridfit for a number of CHAMELEON files. Model must have been loaded
; before calling this procedure.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common MarquardtFit,fit_options
;
if n_elements(chafiles) eq 0 then begin
	chafiles='*.cha'
	print,'Processing all CHAMELEON files...'
endif
;
cha_files=file_search(chafiles)
if strlen(cha_files[0]) eq 0 then begin
	print,'GRIDPIPE: Files not found!'
	return
endif
;
if n_elements(binary_model) eq 0 then begin
	modelfile=''
	read,modelfile,prompt='Please enter name of model file: '
	readmodel,modelfile
endif
;
; print,'Setting fit option "Custom": scale visibilities to model!'
if init_marquardtfit() ne 0 then return
;
for ifile=0,n_elements(cha_files)-1 do begin
	get_data,cha_files[ifile]
	hds_close
	fit_options.f=1
	calcmodel
	fit_options.f=0
	marquardtdata,y,ysig,ymod
	if y[0] ne 0 and ysig[0] ne 0 then gridfit
endfor
;
; Read the results and write astrometry into file
; gridpsn
;
end
