pro gridplot,file_spec,rd=rd,ps=ps,title_all=title_all,model=model
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given one or more YYYY-MM-DD.chisq files, show contour plots.
; If more than one is specified, do not show but save as PS files,
; create LaTex template and compile to create a PDF with all plots.
; Just create EPS files if ps=1. If model is specified, add companion
; position computed with orbit in plots.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_params() eq 0 then begin
	print,'Usage: '+ $
	'gridplot,file_spec,rd=rd,ps=ps,title_all=title_all,model=model'
	return
endif
;
if keyword_set(model) and n_elements(binary_model) eq 0 then begin
	if file_test(model) then begin
		print,'Reading model '+model
		readmodel,model
	endif else begin
		print,'Error:model file not found!'
		retall
	endelse
endif
;
if n_elements(rd) eq 0 then rd=0
if n_elements(ps) eq 0 then ps=0
;
rad=180/!pi
;
files=file_search(file_spec)
if strlen(files[0]) eq 0 then begin
	print,'GRIDFIT: Files not found!'
	return
endif
;
if ps eq 0 then buffer=0 else buffer=1
if n_elements(files) gt 1 then begin
	buffer=1
	openw,unit,'gridplot.tex',/get_lun
	printf,unit,'\documentclass[a4paper,12pt]{article}'
	printf,unit,'\pagestyle{empty}'
;	https://www.sharelatex.com/learn/Page_size_and_margins
	printf,unit,'\usepackage{geometry}'
	printf,unit,'\geometry{left=20mm,top=0mm,}'
	printf,unit,'\usepackage{graphicx}'
	printf,unit,'\usepackage{subcaption}'
	printf,unit,'\begin{document}'
	printf,unit,'\begin{figure}[htb]'
	printf,unit,'\centering'
	printf,unit,'\begin{tabular}{@{}cccc@{}}'
	istring='\includegraphics[width=0.32\textwidth]'
endif
;
for i=0,n_elements(files)-1 do begin
;
restore,files[i]	; restores date,n_deg_free,reduced chisq,rho,theta
index=where(chisq eq min(chisq)) & index=index[0]
if rd then begin
	r_min=sin(theta[index]/rad)*rho[index]
	d_min=cos(theta[index]/rad)*rho[index]
	print,'Minimum Chi^2 found at RA = ',r_min,', DEC =',d_min
	print,'Minimum Chi^2 : ',min(chisq)
endif else begin
	print,'Minimum Chi^2 found at rho= ',rho[index],', theta=',theta[index]
	print,'Minimum Chi^2 : ',min(chisq)
endelse
;
rad=180/!pi
r=sin(theta/rad)*rho	; RA
d=cos(theta/rad)*rho	; Dec
dims=size(r,/dim)
cellsize=float(r[0]-r[1])
if n_elements(files) eq 1 then begin
	print,'Cell size = ',cellsize
	print,'Dimensions: ',fix(dims)
endif
;
; Not needed?
; rho=sqrt(r^2+d^2)
; theta=atan(r,d)*rad
; if max(theta) lt 0 then theta=theta+360.
index=where(theta lt 0)
theta[index]=theta[index]+360
;
!except=0
if rd then print,'Positive RA to the East (left).' $
      else print,'Axes are Theta versus Rho.'
if not keyword_set(title_all) then $
	title=strmid(files[i],0,strpos(files[i],'.',/reverse_search)) $
	else title=title_all
if rd then g=contour(chisq,r,d,c_label_show=0,title=title, $
	xtitle='Right Ascension offset',ytitle='Declination offset', $
;	c_value=[5,7,10,15,25,50], $	; sigma
;	c_value=[1.1,1.2,1.46,2.14]*min(chisq)), $
;	c_value=min(chisq)+findgen(7)*(max(chisq)-min(chisq))/7), $
;	rgb_table=39,font_size=16,buffer=buffer,xrange=[min(r),max(r)]) $
;	Switched max and min in the next line (14.1.2025): RA incr. to the left
	rgb_table=39,font_size=16,buffer=buffer,xrange=[max(r),min(r)]) $
      else g=contour(chisq,rho,theta,c_label_show=0,title=title, $
	xtitle='Separation [mas]',ytitle='Position angle [deg]',rgb_table=39, $
	font_size=16,buffer=buffer, $
	xrange=[min(rho),max(rho)],yrange=[min(theta),max(theta)])
!except=1
;
; Obtain observation date either from new chisq file (restore) or from filename
if n_elements(date) eq 0 then date=strmid(files[i],0,10) ; old method
;
; Over-plot concentric rings at the model position of the secondary
two_ssq=0.5
if rd and keyword_set(model) then begin	; "rd" = "RA,DEC"
	rt=binarypos(date2jd(date))	; "rt" = "Radius,Theta"
	r_m=sin(rt[1]/rad)*rt[0]	; compute RA of secondary
	d_m=cos(rt[1]/rad)*rt[0]	; compute DEC of secondary
	gp=max(chisq)*exp(-(((r-r_m)^2+(d-d_m)^2)/two_ssq)); concentric rings
	g=contour(gp,r,d,/overplot,c_label_show=0,color='r')
	print,'Model position indicated by red oval lines.'
endif else if keyword_set(model) then begin
	sp=fltarr(2)
	sp[*]=binarypos(date2jd(date))	; "sp" = "separation,position angle"
	gp=max(chisq)*exp(-(((r-r_m)^2+(d-d_m)^2)/two_ssq)); concentric rings
	g=contour(gp,rho,theta,/overplot,c_label_show=0,color='r')
;	gp=max(chisq)*exp(-(rho^2+theta^2))
;	gp=max(chisq)*exp(-(((r-r_m)^2+(d-d_m)^2)/two_ssq)); concentric rings
;	g=contour(gp,rho,theta,/overplot,c_label_show=0,color='r')
endif
;
if n_elements(files) gt 1 then begin
	if (i+1) mod 3 eq 0 then t=' & \\' else t=' &'
	printf,unit,istring+'{'+files[i]+'.eps}'+t
	if (i+1) mod 21 eq 0 then begin
		printf,unit,'\end{tabular}'
		printf,unit,'\caption{$\chi^2$ surfaces}'
		printf,unit,'\end{figure}'
		printf,unit,'\begin{figure}[htb]'
		printf,unit,'\centering'
		printf,unit,'\begin{tabular}{@{}cccc@{}}'
	endif
endif
if buffer eq 1 then g.save,files[i]+'.eps'
;
endfor
;
if n_elements(files) gt 1 then begin
	printf,unit,'\end{tabular}'
	printf,unit,'\caption{$\chi^2$ surfaces}'
	printf,unit,'\end{figure}'
	printf,unit,'\end{document}'
	free_lun,unit
	spawn,'latex gridplot'
	spawn,'dvips -o gridplot.ps gridplot.dvi'
	spawn,'/usr/bin/ps2pdf -sPAPERSIZE=a4 gridplot.ps'
endif
;
end
