pro groom_vizier_phot,named_list=named_list
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Procedure to remove photometry given list of filters or a named list.
;
common LocalVizier,starid,phot,ferr,filt
return
;
; Initialize list of filters if a named list has been specified
if keyword_set(named_list) then begin
	r=dc_read_free(!oyster_dir+'source/common/'+'filter.txt',/col,f)
	case named_list of
	'gerard':begin	; select only data for these filters, if available
		g=['Johnson:U','Johnson:B','Johnson:V','Johnson:R', $
		   'Johnson:I',$ 'Johnson:J','Johnson:H','Johnson:K', $
		   'Stroemgren:U','Stroemgren:B', $
		   'Stroemgren:V','Stroemgren:Y', $
		   'Gaia:G', $
		   '2MASS:J','2MASS:H','2MASS:K','2MASS:Ks']
		end
	endcase
;	Make sure you don't select filters not known to OYSTER
	index=whereequal(filt,g)
	filt=filt[index]
	ferr=ferr[index]
	phot=phot[index,*]
;	Sort by wavelength
	si=sort(phot[*,0])
	phot=phot[si,*]
	filt=filt[si]
	ferr=ferr[si]
endif
index=where(ferr gt 0,count)
phot=phot[index,*]
filt=filt[index]
ferr=ferr[index]
;
return	; ---------------------------------------------------------------------
;
; For each VIZIER filter, check if photometry is available for it
;for i=0,n_elements(filters)-1 do begin
;	index=where(strpos(filt,filters(i)) lt 0,nfilt)
;	if nfilt gt 0 then filt(index)=''
;	if nfilt ge 1 then begin
;		phot=phot(index,*)
;		ferr=ferr(index)
;		filt=filt(index)
;	endif
;endfor
;
; Filter not included: do not use
index=where(strpos(filt,'GALEX:FUV') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(strpos(filt,'GALEX:NUV') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(filt ne 'SDSS:g',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'SDSS:r',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'SDSS:i',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'SDSS:u',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'SDSS:z',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(strpos(filt,'SDSS') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(strpos(filt,'HIP:Hp') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'HIP:BT',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'HIP:VT',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Gaia:G',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(strpos(filt,'GAIA/GAIA3:G') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(strpos(filt,'GAIA/GAIA2:G') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(strpos(filt,'GAIA/GAIA2:Grp') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(strpos(filt,'GAIA/GAIA3:Grp') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:U',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:B',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:V',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:R',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:I',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:J',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:H',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:K',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:L',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:M',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Johnson:N',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Cousins:V',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Cousins:B',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Cousins:I',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Cousins:R',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(strpos(filt,'IRAS') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(strpos(filt,'VISTA:J') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(filt ne 'VISTA:Ks',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(strpos(filt,'2MASS:J') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(strpos(filt,'2MASS:H') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(strpos(filt,'2MASS:Ks') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(strpos(filt,'AKARI:S9W') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(strpos(filt,'AKARI:L18W') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(filt ne 'Spitzer',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'Spitzer/MIPS',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(strpos(filt,'Subaru') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(strpos(filt,'XMM-OT') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(strpos(filt,'PAN-STARRS') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(strpos(filt,'WISE') lt 0,nfilt)
phot=phot[index,*]
ferr=ferr[index]
filt=filt[index]
index=where(filt ne 'SkyMapper/SkyMapper:g',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'SkyMapper/SkyMapper:i',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'SkyMapper/SkyMapper:u',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'SkyMapper/SkyMapper:r',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'SkyMapper/SkyMapper:z',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'MIPS:24',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'CTIO/DECam:i',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'CTIO/DECam:r',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'CTIO/DECam:g',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'CTIO/DECam:z',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
index=where(filt ne 'CTIO/DECam:Y',nfilt)
phot=phot[index,*]
ferr=ferr[index,*]
filt=filt[index]
;
end
