function groupdelay,p,l,d,gindex,plot=plot
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Obtain peak position of power spectrum of complex visibilities.
;
; p=power spectrum or complex dft of complex visibility
; l=wavelength array
; d=array of delays for power spectrum
;
n=(2*!pi)/reform(l)
a=abs(p)
;
num=n_elements(a[0,*])
index=indgen(n_elements(a[*,0]))
g=fltarr(num)
pv1=g
pv2=g
;
for i=0l,num-1 do begin
	j=where(max(a[*,i]) eq a[*,i]) & j=j[0]
	if j gt 1 and j lt n_elements(d)-2 then begin
		r=poly_fit([d[j-2],d[j-1],d[j],d[j+1],d[j+2]]*1e6, $
			   [a[j-2,i],a[j-1,i],a[j,i],a[j+1,i],a[j+2,i]],2)
		pv1[i]=max(a[*,i])
;		pv2(i)=max(a(*,i)-(poly(d*1e6,r) > 0))
		pv2[i]=max(a[where(abs(index-j)*(d[1]-d[0]) gt 3e-6),i])
		g[i]=(-r[1]/(2*r[2]))/1e6
	endif
endfor
;
if num eq 1 then return,g
;
index=where(pv1 gt 0 and pv2 gt 0)
pv1e=pv1[index]
pv2e=pv2[index]
maxv=2*median(pv2e)
bins=maxv/40
;
if keyword_set(plot) then begin
	title=!p.title
	set_screen
	!p.title=title
	!p.charsize=2
	case plot of
	      1:begin
		window,xsize=500,ysize=400,/free
		!x.title='Primary/secondary peak values'
		!y.range=[0,max([max(histogram(pv1e,binsize=bins*3)), $
				 max(histogram(pv2e,binsize=bins))])]
		histograph,pv1e,min=0,max=maxv*3,binsize=bins*3
		histograph,pv2e,min=0,max=maxv*3,binsize=bins,/oplot,color=tci(2)
		end
	      2:begin
		window,xsize=600,ysize=fix(600*(0.27/0.25)),/free
		!x.margin=[10,5]
		!y.margin=[6,3]
		!x.title='Primary peak value'
		!y.title='Secondary peak value'
		plot,pv1e,pv2e,psym=3,yrange=[0,max(pv1e)],xrange=[0,max(pv1e)]
		oplot,findgen(max(pv1e)),findgen(max(pv1e)),psym=0
		end
	endcase
	!x.title=''
	!y.title=''
endif
;
; Determine which samples are probably bad
method=2
;
case method of
1: 	begin
	h=histogram(pv2e,min=0,max=maxv,binsize=bins)
	hc=0.0
	hr=float(h)/total(h)
	i=0
	repeat begin
		hc=hc+hr[i]
		i=i+1
	endrep until hc gt 0.95
	threshold=bins*i
	ipv1=where(pv1 ge threshold)
	if n_params() eq 4 then $
	print,n_elements(ipv1),' out of ',n_elements(pv1), $
		' samples above threshold of ',threshold, $
		format='(i0,a,i0,a,f5.0)'
	end
2: 	begin
	h=histogram(pv2e,min=0,max=maxv,binsize=bins)
	i=where(h eq max(h))
	threshold_r=1.20
	threshold_a=i[0]*bins*threshold_r
	ipv1=where(pv1 gt pv2*threshold_r $
	       and pv1 gt threshold_a)
	if n_params() eq 4 then $
	print,n_elements(ipv1),' out of ',n_elements(pv1), $
		' samples above threshold of ',threshold_a, $
		format='(i0,a,i0,a,f5.0)'
	end
endcase
;
gindex=lonarr(num)
gindex[ipv1]=1
;
return,g
;
end
