function groupdelays,baseline,beam,scanfile, $
		channels=channels,numav=numav,gindex=gindex,plot=plot
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and return groupdelay for specified baseline.
; Must have used get_rawdata first!
; If scanfile defined, compute and concatenate for all sub-scans.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(scanfile) ne 0 then scanfiles=file_search(scanfile+'.??') $
			     else scanfiles=''
;
if n_elements(beam) eq 0 then beam=OutputBeam $
			 else if n_elements(scanfile) eq 0 $
			 	then get_bincounts,beam
ob=beam-1
bl=baseline-1
if n_elements(channels) eq 0 then $
	channels=channelindex[genconfig.spectrometerid[ob]]
ch=channels-1
;
if n_elements(numav) eq 0 then numav=1
;
l=genconfig.wavelength[ch,ob]
d=gitter(121,-12e-6)
;
f=fdldelay(genconfig.baselineid[bl,ob],scan=n_elements(scanfile))
delay=fltarr(n_elements(f))
gindex=intarr(n_elements(f))
;
for i=0,n_elements(scanfiles)-1 do begin
	if strlen(scanfiles[i]) gt 0 then begin
		hds_open,scanfiles[i]
		get_bincounts,beam
		hds_close
	endif
	v=fringevis(bincounts[*,ch,*],genconfig.fringemod[bl,ob])
	delay[Raw0:RawN]=groupdelay(box(abs(visdft(v,l,d)),numav,1),l,d,index, $
		plot=plot)
	gindex[Raw0:RawN]=index
endfor
;
return,delay
;
end
