function gsmooth,t,y,s,x,c8=c8
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Gaussian smoothing of y(t), with FWHM=s. Return result itself, or result
; interpolated on grid x.
;
if n_elements(c8) eq 0 then c8=0
;
nt=n_elements(t)
;
if c8 then begin
	t8=double(t)
	y8=double(y)
	s8=double(s)
	n=n_elements(y8)
	r8=dblarr(n)
	status=linknload(!external_lib,'gsmooth8',t8,y8,s8,n,r8)
	r=float(r8)
endif else begin
	r=y
	a=sqrt(10)*s
	for i=0l,nt-1 do begin
		dt=abs(t-t[i])
		index=where(dt lt a)
		w=exp(-(dt[index]/s)^2)
		r[i]=total(y[index]*w)/total(w)
	endfor
endelse
;
if n_elements(x) ne 0 then begin
	result=x
	index=where(x lt t[0],count)
	if count gt 0 then result[index]=r[0]
	index=where(x gt t[0],count)
	if count gt 0 then result[index]=r[nt-1]
	index=where(x ge t[0] and x le t[nt-1],count)
	if count gt 0 then result[index]=interpol(r,t,x[index])
	r=result
endif
;
return,r
;
end
