function h_2mass,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; http://svo2.cab.inta-csic.es/theory/fps/index.php?mode=browse
;
; To use this procedure, one has to create the ASCI template as follows:
; template=ascii_template('~/oyster/svo/2mass/H.txt')
; save,template,file='~/oyster/svo/2mass/H.tpl'
; The template can then be used to read the data:
; restore,'~/oyster/svo/2mass/H.tpl'
; data=read_ascii('~/oyster/svo/2mass/H.txt',template=template)
;
restore,'~/oyster/svo/2mass/H.tpl'
data=read_ascii('~/oyster/svo/2mass/H.txt',template=template)
l=data.field1*1000	; convert microns to nm
t=data.field2
;
if n_elements(lambda) eq 0 then begin
	lambda=l
; 	Return "central" wavelength
	return,total(l*t)/total(t)
endif
return,response(l,t,lambda)
;
end
