function hadec2equatorial,a_coord
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Convert hour angle and declination to equatorial XYZ coordinates. Note that
; the X-axis is along local meridian, NOT the Greenwich meridian as used in VLBI
; This corresponds to the X,Y,Z system used by Thompson, Moran and Swenson
; "Interferometry and Synthesis in Radio Astronomy", page 86 (1st Edition).
; That is, Z points towards the north pole along the earth's rotational axis,
; X along the projection of the local meridian on the equator, increasing as
; you go from the earth's axis to the local point on the earth's surface and
; Y points east.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
b=fltarr(1,n_elements(a_coord[0,*]))
e_coord=[a_coord,b]
e_coord[2,*]=+sin(a_coord[1,*]/RAD)
e_coord[1,*]=-sin(a_coord[0,*]*15/RAD)*cos(a_coord[1,*]/RAD)
e_coord[0,*]=+cos(a_coord[0,*]*15/RAD)*cos(a_coord[1,*]/RAD)
;
return,e_coord
;
end
