function hb,uv,v2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This function returns for a given uv spacing (in millions of wavelengths)
; and calibrated squared visibility amplitude the diameter of the star [mas].
; The computation is non-iterative, since it uses polynomial fit coefficients
; determined for a grid of spacings and visibilities. The function works
; only reliably if v2 > 0.1 and v2 < 0.9.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
factor=(pi_circle^2)/(180L*3600L*1000L)
;
if n_elements(uv) eq 1 then begin
	u=v2
	u[*]=uv[0]
	uv=u
endif
;
; These coefficients are for a 3rd order fit of the d=f(v2)
; coefficients to the uv spacings.
coeff11=[10.8555,-1.52880,0.0975650,-0.00215141]
coeff21=[3.37067,-0.0641237,0.000618756,-2.44172e-06]
coeff12=[-12.2294,1.49343,-0.0793799,0.00141445]
coeff22=[-3.75824,0.0642599,-0.000620554,2.45088e-06]
coeff13=[11.6333,-1.21883,0.0499391,-0.000526415]
coeff23=[3.73860,-0.0645361,0.000624810,-2.47455e-06]
coeff14=[10.3883,-1.14758,0.0501068,-0.000630298]
coeff24=[3.23568,-0.0646144,0.000626390,-2.48441e-06]
;
; Get polynomial coefficients for given uv distance. There are two sets
; because of a discontinuity at 18 Mlambda.
d=fltarr(n_elements(uv))
;
for i=0,n_elements(uv)-1 do begin
if uv[i] le 18 then r=exp([poly(uv[i],coeff11),-poly(uv[i],coeff12), $
                        poly(uv[i],coeff13),poly(uv[i],coeff14)]) $
               else r=exp([poly(uv[i],coeff21),-poly(uv[i],coeff22), $
                        poly(uv[i],coeff23),poly(uv[i],coeff24)])
;
; Get diameter for given uv and v2
d[i]=poly(v2[i],r*[1,-1,1,-1])
endfor
;
return,d
;
; Test
uvdist=uv*1e6
arg=factor*uvdist*d
visamp=2*beselj(arg,1)/arg
vissq=visamp^2
print,'V2 should be ',vissq
;
end
