pro hdn_startable,targets
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; OYSTER uses the SkyCat 2.0 (Sky Publishing) for HDN star IDs, but HD numbers
; not found here (often the case with MIDI calibrators) have to be added
; manually to HDN.xdr. This procedure gets the basic information from simbad
; and stores it into a startable. Use edit_startable to check results, and
; update_cat to add the entries to HDN.xdr. Targets are resolved by SimBad.
;
common StarBase,StarTable,Notes
;
n=n_elements(targets)
if n eq 0 then return
;
; Make sure the ID comes with the catalog name
index=where(strpos(targets,'HD') eq -1,count)
if count gt 0 then begin
	print,'Please include catalog name in target names, e.g., HDN123456!'
	return
endif
;
create_startable,targets
hdn=intarr(n)
stars=strarr(n)
;
print,'Number of targets to send to SimBad: ',n
;
success=0
;
for i=0,n-1 do begin
	print,'Retrieving info for target #',i+1
;	print,format='(%"Retrieving info for target: %s\r")',targets(i)
	star=cri_simbad(targets[i],t)
;	starid=cri_simbad(startable(i).name,t)
	if strlen(star) ne 0 then begin
		table=startable[i]
		struct_assign,t,table
		startable[i]=table
		startable[i].name=star
		success=1
	endif else begin
		print,'Warning (hdn_startable): not found:',targets[i]
	endelse
;	if strpos(starid,'HD') ge 0 then begin
;		startable(i).hdn=t.hdn
;		startable(i).starid='HDN'+string(startable(i).hdn,format='(i6.6)')
;		table=startable(i)
;		struct_assign,t,table
;		startable(i)=table
;		words=nameparse(targets(i))
;		startable(i).name=strjoin(words,'_')
;	endif
endfor
;
if success then begin
	print,'Use edit_startable to check/correct results for each star.'
	print,'If no HD number is listed, the object was not found!'
	print,'If not found, run procedure usr_startable instead.'
	print,'If found, use update_cat to add star to catalogs/hdn/HDN.xdr'
endif
;
end
