pro hds_new,filename,name,type,status
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Opens new HDS file (overwriting existing one) and returns status.
;
common Hds,path,hds_file_stub
;
if hds_state() ne 0 then begin
	print,'***Error: Please close current file before opening another one!'
	status=-1
	return
endif
;
if n_elements(filename) eq 0 then begin
	filename=''
	read,'Please enter HDS file name: ',filename
endif
;
if n_elements(name) eq 0 then begin
	name=''
	read,'Please enter name of toplevel object to be created: ',name
endif
;
if n_elements(type) eq 0 then begin
	type=''
	read,'Please enter type of toplevel object to be created: ',type
endif
;
ndim=0L
dims=lonarr(7)
status=linknload(!external_lib,'hds_new',filename,name,type,ndim,dims)
if status ne 0 then begin
	print,'***Error: error creating file!'
	return
endif
print,'File '+filename+' created.'
status=0
;
end
